/*
 * Decompiled with CFR 0.152.
 */
package vesper.substrate;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.jetbrains.annotations.NotNull;
import vesper.substrate.CameraController;

@Mod(value="substrate", dist={Dist.CLIENT})
@EventBusSubscriber(modid="substrate", value={Dist.CLIENT})
public class SubstrateClient {
    public static final CameraController cameraController = new CameraController();
    public static final AtomicBoolean enabled = new AtomicBoolean(true);
    public static final AtomicBoolean serverDisabled = new AtomicBoolean(false);
    public static AtomicInteger ceilingY = new AtomicInteger(Integer.MAX_VALUE);
    public static AtomicInteger floorY = new AtomicInteger(Integer.MIN_VALUE);

    public SubstrateClient(IEventBus bus) {
    }

    @SubscribeEvent
    static void onClientSetup(FMLClientSetupEvent event) {
    }

    static void onEndTick(LevelTickEvent.Post event) {
        cameraController.handleEndTick();
    }

    public static boolean shouldRender(@NotNull BlockPos pos, @NotNull Direction facing) {
        if (!enabled.get() || serverDisabled.get()) {
            return true;
        }
        int y = pos.getY();
        return switch (facing) {
            case Direction.DOWN -> {
                boolean isFloor;
                boolean v0 = isFloor = floorY.get() != Integer.MIN_VALUE && y == floorY.get();
                if (!isFloor || CameraController.belowFloor.get()) {
                    yield true;
                }
                yield false;
            }
            case Direction.UP -> {
                boolean isCeiling;
                boolean v2 = isCeiling = ceilingY.get() != Integer.MAX_VALUE && y == ceilingY.get();
                if (!isCeiling || CameraController.aboveCeiling.get()) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }
}

