/*
 * Decompiled with CFR 0.152.
 */
package vesper.substrate;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.SectionPos;
import net.minecraft.world.phys.Vec3;
import vesper.substrate.SubstrateClient;

public class CameraController {
    public static AtomicBoolean belowFloor = new AtomicBoolean(false);
    public static AtomicBoolean aboveCeiling = new AtomicBoolean(false);

    public void handleEndTick() {
        boolean newAboveCeiling;
        if (!SubstrateClient.enabled.get() || SubstrateClient.serverDisabled.get()) {
            return;
        }
        double cameraY = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().y;
        int currentFloorY = SubstrateClient.floorY;
        int currentCeilingY = SubstrateClient.ceilingY;
        boolean newBelowFloor = currentFloorY != Integer.MIN_VALUE && cameraY < (double)currentFloorY;
        boolean bl = newAboveCeiling = currentCeilingY != Integer.MAX_VALUE && cameraY > (double)currentCeilingY;
        if (newBelowFloor != belowFloor.get()) {
            belowFloor.set(newBelowFloor);
            this.renderLayer(currentFloorY);
        }
        if (newAboveCeiling != aboveCeiling.get()) {
            aboveCeiling.set(newAboveCeiling);
            this.renderLayer(currentCeilingY);
        }
    }

    private void renderLayer(int y) {
        if (y == -1) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            return;
        }
        Vec3 camera = minecraft.gameRenderer.getMainCamera().getPosition();
        int sx = SectionPos.blockToSectionCoord((double)camera.x);
        int sy = SectionPos.blockToSectionCoord((int)y);
        int sz = SectionPos.blockToSectionCoord((double)camera.z);
        LevelRenderer levelRenderer = minecraft.levelRenderer;
        int dist = (int)(levelRenderer.getLastViewDistance() + 1.0);
        for (int x = sx - dist; x <= sx + dist; ++x) {
            for (int z = sz - dist; z <= sz + dist; ++z) {
                levelRenderer.setSectionDirtyWithNeighbors(x, sy, z);
            }
        }
    }

    public void updateVisibility() {
        this.renderLayer(SubstrateClient.floorY);
        this.renderLayer(SubstrateClient.ceilingY);
    }
}

