/*
 * Decompiled with CFR 0.152.
 */
package vesper.substrate;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.phys.Vec3;
import vesper.substrate.SubstrateClient;

public class CameraController {
    public static AtomicBoolean belowFloor = new AtomicBoolean(false);
    public static AtomicBoolean aboveCeiling = new AtomicBoolean(false);

    public void handleEndTick() {
        boolean newAboveCeiling;
        if (!SubstrateClient.enabled.get() || SubstrateClient.serverDisabled.get()) {
            return;
        }
        AtomicDouble cameraY = new AtomicDouble((double)Minecraft.getInstance().gameRenderer.getMainCamera().getBlockPosition().getY());
        AtomicInteger currentFloorY = new AtomicInteger(SubstrateClient.floorY.get());
        AtomicInteger currentCeilingY = new AtomicInteger(SubstrateClient.ceilingY.get());
        boolean newBelowFloor = currentFloorY.get() != Integer.MIN_VALUE && cameraY.get() < (double)currentFloorY.get();
        boolean bl = newAboveCeiling = currentCeilingY.get() != Integer.MAX_VALUE && cameraY.get() > (double)currentCeilingY.get();
        if (newBelowFloor != belowFloor.get()) {
            belowFloor.set(newBelowFloor);
            this.renderLayer(currentFloorY.get());
        }
        if (newAboveCeiling != aboveCeiling.get()) {
            aboveCeiling.set(newAboveCeiling);
            this.renderLayer(currentCeilingY.get());
        }
    }

    private void renderLayer(int y) {
        if (y == -1) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            return;
        }
        Vec3 camera = minecraft.gameRenderer.getMainCamera().getPosition();
        int sx = SectionPos.blockToSectionCoord((double)camera.x);
        int sy = SectionPos.blockToSectionCoord((int)y);
        int sz = SectionPos.blockToSectionCoord((double)camera.z);
        LevelRenderer levelRenderer = minecraft.levelRenderer;
        int dist = (int)(levelRenderer.getLastViewDistance() + 1.0);
        for (int x = sx - dist; x <= sx + dist; ++x) {
            for (int z = sz - dist; z <= sz + dist; ++z) {
                levelRenderer.setSectionDirtyWithNeighbors(x, sy, z);
            }
        }
    }

    public void updateVisibility() {
        this.renderLayer(SubstrateClient.floorY.get());
        this.renderLayer(SubstrateClient.ceilingY.get());
    }

    public void updateVisibilityAround(BlockPos center) {
        this.renderLayerAt(SubstrateClient.floorY.get(), center);
        this.renderLayerAt(SubstrateClient.ceilingY.get(), center);
    }

    private void renderLayerAt(int y, BlockPos center) {
        if (y == -1) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        ClientLevel world = client.level;
        if (world == null) {
            return;
        }
        int sx = SectionPos.blockToSectionCoord((int)center.getX());
        int sy = SectionPos.blockToSectionCoord((int)y);
        int sz = SectionPos.blockToSectionCoord((int)center.getZ());
        LevelRenderer worldRenderer = client.levelRenderer;
        int dist = (int)(worldRenderer.getLastViewDistance() + 3.0);
        for (int x = sx - dist; x <= sx + dist; ++x) {
            for (int z = sz - dist; z <= sz + dist; ++z) {
                worldRenderer.setSectionDirty(x, sy, z);
            }
        }
    }
}

