/*
 * Decompiled with CFR 0.152.
 */
package vesper.substrate.mixin.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vesper.substrate.SubstrateClient;

@Mixin(value={ClientLevel.class})
public class ClientLevelMixin {
    @Inject(method={"onChunkLoaded"}, at={@At(value="RETURN")})
    private void onChunkLoad(ChunkPos chunkPos, CallbackInfo ci) {
        if (!SubstrateClient.enabled.get() || SubstrateClient.serverDisabled.get()) {
            return;
        }
        if (Minecraft.getInstance().levelRenderer != null) {
            int dist = (int)Minecraft.getInstance().levelRenderer.getLastViewDistance() + 1;
            for (int x = chunkPos.x - dist; x <= chunkPos.x + dist; ++x) {
                for (int z = chunkPos.z - dist; z <= chunkPos.z + dist; ++z) {
                    int sy;
                    if (SubstrateClient.floorY.get() != Integer.MIN_VALUE) {
                        sy = SectionPos.blockToSectionCoord((int)SubstrateClient.floorY.get());
                        Minecraft.getInstance().levelRenderer.setSectionDirtyWithNeighbors(x, sy, z);
                    }
                    if (SubstrateClient.ceilingY.get() == Integer.MAX_VALUE) continue;
                    sy = SectionPos.blockToSectionCoord((int)SubstrateClient.ceilingY.get());
                    Minecraft.getInstance().levelRenderer.setSectionDirtyWithNeighbors(x, sy, z);
                }
            }
        }
    }
}

