/*
 * Decompiled with CFR 0.152.
 */
package vesper.substrate;

import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import org.jetbrains.annotations.NotNull;
import vesper.substrate.CameraController;

@Environment(value=EnvType.CLIENT)
public final class Substrate
implements ClientModInitializer {
    private static final class_2960 CHANNEL = class_2960.method_60655((String)"substrate", (String)"v1");
    public static final CameraController cameraController = new CameraController();
    private static class_304 KEY = new class_304("substrate.toggle", class_3675.class_307.field_1668, 82, "substrate.category");
    public static final AtomicBoolean enabled = new AtomicBoolean(true);
    public static final AtomicBoolean serverDisabled = new AtomicBoolean(false);
    public static volatile int floorY = Integer.MIN_VALUE;
    public static volatile int ceilingY = Integer.MAX_VALUE;

    public void onInitializeClient() {
        KEY = KeyBindingHelper.registerKeyBinding((class_304)KEY);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (!KEY.method_1436()) {
                return;
            }
            if (serverDisabled.get()) {
                client.field_1705.method_1758((class_2561)class_2561.method_43471((String)"substrate.toggle.server").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067}), false);
                return;
            }
            boolean newState = !enabled.get();
            enabled.set(newState);
            cameraController.updateVisibility();
            client.field_1769.method_3279();
            client.field_1705.method_1758((class_2561)class_2561.method_43471((String)(enabled.get() ? "substrate.toggle.on" : "substrate.toggle.off")).method_27695(new class_124[]{enabled.get() ? class_124.field_1060 : class_124.field_1061, class_124.field_1067}), false);
        });
        ClientTickEvents.END_WORLD_TICK.register(world -> cameraController.handleEndTick());
        ClientLoginNetworking.registerGlobalReceiver((class_2960)CHANNEL, (client, handler, buf, sender) -> {
            try {
                serverDisabled.set(buf.readBoolean());
            }
            catch (Throwable ignored) {
                serverDisabled.set(true);
            }
            client.execute(() -> {
                if (client.field_1687 != null) {
                    String msg;
                    client.field_1769.method_3279();
                    String string = serverDisabled.get() ? "substrate.toggle.server" : (msg = enabled.get() ? "substrate.toggle.on" : "substrate.toggle.off");
                    class_124 formatting = serverDisabled.get() ? class_124.field_1079 : (enabled.get() ? class_124.field_1060 : class_124.field_1061);
                    client.field_1705.method_1758((class_2561)class_2561.method_43471((String)msg).method_27695(new class_124[]{formatting, class_124.field_1067}), false);
                }
            });
            return null;
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> serverDisabled.set(false));
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> serverDisabled.set(false));
    }

    public static boolean shouldRender(@NotNull class_2338 pos, @NotNull class_2350 facing) {
        if (!enabled.get() || serverDisabled.get()) {
            return true;
        }
        int y = pos.method_10264();
        return switch (facing) {
            case class_2350.field_11033 -> {
                boolean isFloor;
                boolean v0 = isFloor = floorY != Integer.MIN_VALUE && y == floorY;
                if (!isFloor || CameraController.belowFloor.get()) {
                    yield true;
                }
                yield false;
            }
            case class_2350.field_11036 -> {
                boolean isCeiling;
                boolean v2 = isCeiling = ceilingY != Integer.MAX_VALUE && y == ceilingY;
                if (!isCeiling || CameraController.aboveCeiling.get()) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }
}

