/*
 * Decompiled with CFR 0.152.
 */
package vesper.substrate;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_638;
import net.minecraft.class_761;
import vesper.substrate.Substrate;

@Environment(value=EnvType.CLIENT)
public final class CameraController {
    public static AtomicBoolean belowFloor = new AtomicBoolean(false);
    public static AtomicBoolean aboveCeiling = new AtomicBoolean(false);

    public void handleEndTick() {
        boolean newAboveCeiling;
        if (!Substrate.enabled.get() || Substrate.serverDisabled.get()) {
            return;
        }
        AtomicDouble cameraY = new AtomicDouble(class_310.method_1551().field_1773.method_19418().method_19326().field_1351);
        AtomicInteger currentFloorY = new AtomicInteger(Substrate.floorY.get());
        AtomicInteger currentCeilingY = new AtomicInteger(Substrate.ceilingY.get());
        boolean newBelowFloor = currentFloorY.get() != Integer.MIN_VALUE && cameraY.get() < (double)currentFloorY.get();
        boolean bl = newAboveCeiling = currentCeilingY.get() != Integer.MAX_VALUE && cameraY.get() > (double)currentCeilingY.get();
        if (newBelowFloor != belowFloor.get()) {
            belowFloor.set(newBelowFloor);
            this.renderLayer(currentFloorY.get());
        }
        if (newAboveCeiling != aboveCeiling.get()) {
            aboveCeiling.set(newAboveCeiling);
            this.renderLayer(currentCeilingY.get());
        }
    }

    private void renderLayer(int y) {
        if (y == -1) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        if (world == null) {
            return;
        }
        class_243 camera = client.field_1773.method_19418().method_19326();
        int sx = class_4076.method_32204((double)camera.field_1352);
        int sy = class_4076.method_18675((int)y);
        int sz = class_4076.method_32204((double)camera.field_1350);
        class_761 worldRenderer = client.field_1769;
        int dist = (int)(worldRenderer.method_34812() + 1.0);
        for (int x = sx - dist; x <= sx + dist; ++x) {
            for (int z = sz - dist; z <= sz + dist; ++z) {
                worldRenderer.method_18145(x, sy, z);
            }
        }
    }

    public void updateVisibility() {
        this.renderLayer(Substrate.floorY.get());
        this.renderLayer(Substrate.ceilingY.get());
    }

    public void updateVisibilityAround(class_2338 center) {
        this.renderLayerAt(Substrate.floorY.get(), center);
        this.renderLayerAt(Substrate.ceilingY.get(), center);
    }

    private void renderLayerAt(int y, class_2338 center) {
        if (y == -1) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        if (world == null) {
            return;
        }
        int sx = class_4076.method_18675((int)center.method_10263());
        int sy = class_4076.method_18675((int)y);
        int sz = class_4076.method_18675((int)center.method_10260());
        class_761 worldRenderer = client.field_1769;
        int dist = (int)(worldRenderer.method_34812() + 3.0);
        for (int x = sx - dist; x <= sx + dist; ++x) {
            for (int z = sz - dist; z <= sz + dist; ++z) {
                worldRenderer.method_8571(x, sy, z);
            }
        }
    }
}

