/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack;

import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackHelper;
import com.yyz.yyzsbackpack.BackpackPlatform;
import com.yyz.yyzsbackpack.api.BackPackSlot;
import com.yyz.yyzsbackpack.api.BackpackCondition;
import com.yyz.yyzsbackpack.api.EquipPackSlot;
import com.yyz.yyzsbackpack.item.BackpackItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BackpackManager {
    public static final ResourceLocation BACKPACK_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"yyzsbackpack", (String)"textures/gui/backpack.png");
    public static final ResourceLocation BACKSLOT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"yyzsbackpack", (String)"item/backslot");
    public static final ResourceLocation SLOT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"yyzsbackpack", (String)"textures/gui/slot.png");

    public static void updateBackpackSlotsPosition(AbstractContainerMenu menu, int backpackSlotStartIndex, int baseHeight, int xOffset, int yOffset) {
        int rows = 9;
        for (int column = 0; column < 6; ++column) {
            for (int row = 0; row < 9; ++row) {
                Slot slot;
                int slotIndex = backpackSlotStartIndex + column * 9 + row;
                if (slotIndex >= menu.slots.size() || !((slot = (Slot)menu.slots.get(slotIndex)) instanceof BackPackSlot)) continue;
                slot.x = -25 - column * 18 + xOffset;
                slot.y = (baseHeight - 166) / 2 + 3 + row * 18 + yOffset;
            }
        }
    }

    public static void updateEquipmentSlotPosition(AbstractContainerMenu menu, int baseHeight, int xOffset, int yOffset) {
        for (Slot slot : menu.slots) {
            if (!(slot instanceof EquipPackSlot)) continue;
            slot.x = 77 + xOffset;
            slot.y = (baseHeight - 166) / 2 + 8 + 36 + yOffset;
            break;
        }
    }

    public static void addBackpackSlots(AbstractContainerMenu screenHandler, Inventory inventory) {
        for (int column = 0; column < 6; ++column) {
            for (int row = 0; row < 9; ++row) {
                int columnIndex = column;
                screenHandler.addSlot((Slot)new BackPackSlot(screenHandler, inventory, row + (column + 1) * 9 + 27, columnIndex, 0, 0));
            }
        }
    }

    public static boolean isTrinketModLoaded() {
        return BackpackHelper.isModLoaded("trinkets") || BackpackHelper.isModLoaded("curios") || BackpackHelper.isModLoaded("accessories");
    }

    public static void renderEquippackSlot(InventoryMenu menu, GuiGraphics guiGraphics, int x, int y) {
        if (BackpackManager.isTrinketModLoaded() && !Backpack.getConfig().force_slot) {
            return;
        }
        guiGraphics.blit(SLOT_TEXTURE, x + ((BackpackCondition)menu).getEquippackXOffset(), y + ((BackpackCondition)menu).getEquippackYOffset(), 0.0f, 0.0f, 18, 18, 18, 18);
    }

    public static void addEquipmentSlot(AbstractContainerMenu screenHandler, Inventory inventory) {
        if (BackpackManager.isTrinketModLoaded() && !Backpack.getConfig().force_slot) {
            return;
        }
        screenHandler.addSlot((Slot)new EquipPackSlot((Container)inventory, 90, 77, 44){});
    }

    public static void saveBackpackContents(Container inventory, ItemStack backpackStack, boolean b) {
        BackpackItem backpackItem = (BackpackItem)backpackStack.getItem();
        int columns = backpackItem.getBackpackType().getColumns();
        int numSlots = columns * 9;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(numSlots);
        for (int i = 0; i < numSlots; ++i) {
            int slotIndex = 36 + i;
            ItemStack stack = inventory.getItem(slotIndex);
            items.add(stack.copy());
            if (!b) continue;
            inventory.setItem(slotIndex, ItemStack.EMPTY);
        }
        backpackStack.set(BackpackPlatform.getBackpackItemsComponent(), items);
    }

    public static void restoreBackpackContents(Container inventory, ItemStack backpackStack) {
        List items = (List)backpackStack.get(BackpackPlatform.getBackpackItemsComponent());
        if (items == null) {
            return;
        }
        BackpackItem backpackItem = (BackpackItem)backpackStack.getItem();
        int columns = backpackItem.getBackpackType().getColumns();
        int numSlots = columns * 9;
        for (int i = 0; i < Math.min(items.size(), numSlots); ++i) {
            ItemStack stack = (ItemStack)items.get(i);
            if (stack.isEmpty()) continue;
            inventory.setItem(36 + i, stack.copy());
        }
        backpackStack.remove(BackpackPlatform.getBackpackItemsComponent());
    }

    public static void renderBackpackBackground(GuiGraphics context, int x, int y, int backgroundWidth, int backgroundHeight, Inventory inventory, boolean shouldRenderBackpack, BackpackCondition renderCondition) {
        if (!shouldRenderBackpack) {
            return;
        }
        int columns = 0;
        ItemStack stack = BackpackHelper.getEquipped(inventory.player);
        Item item = stack.getItem();
        if (item instanceof BackpackItem) {
            BackpackItem backpackItem = (BackpackItem)item;
            columns = backpackItem.getBackpackType().getColumns();
        }
        int width = 14 + columns * 18;
        int left = x - 14 - columns * 18 - 1 + renderCondition.getBackpackXOffset();
        int top = y + (backgroundHeight - 174) / 2 + renderCondition.getBackpackYOffset();
        int u = 14 * (columns - 1) + 18 * (columns - 1) * columns / 2;
        context.blit(BACKPACK_TEXTURE, left, top, (float)u, 0.0f, width, 174, 462, 174);
    }

    public static boolean shouldRenderBackpackExtension(AbstractContainerMenu handler, Inventory inventory) {
        if (inventory != null && ((BackpackCondition)handler).shouldRenderBackpack()) {
            ItemStack backpackStack = BackpackHelper.getEquipped(inventory.player);
            return backpackStack.getItem() instanceof BackpackItem;
        }
        return false;
    }

    public static boolean isClickOutsideExtendedBounds(Inventory inventory, boolean outsideOriginalBounds, double mouseX, double mouseY, int left, int top, int backgroundWidth, int backgroundHeight, boolean shouldRenderBackpackExtension, BackpackCondition renderCondition) {
        boolean inBackpackArea = false;
        if (shouldRenderBackpackExtension) {
            int columns = 0;
            ItemStack backpackStack = BackpackHelper.getEquipped(inventory.player);
            Item item = backpackStack.getItem();
            if (item instanceof BackpackItem) {
                BackpackItem backpack = (BackpackItem)item;
                columns = backpack.getBackpackType().getColumns();
            }
            int backpackWidth = 14 + columns * 18;
            int backpackX = left - backpackWidth - 1 + renderCondition.getBackpackXOffset();
            int backpackY = top + (backgroundHeight - 174) / 2 + renderCondition.getBackpackYOffset();
            int backpackHeight = 174;
            inBackpackArea = mouseX >= (double)backpackX && mouseX < (double)(backpackX + backpackWidth) && mouseY >= (double)backpackY && mouseY < (double)(backpackY + backpackHeight);
        }
        return outsideOriginalBounds && !inBackpackArea;
    }

    public static class Ref<T> {
        public T value;

        public Ref(T value) {
            this.value = value;
        }
    }
}

