/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.neoforge;

import com.mojang.serialization.Codec;
import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackHelper;
import com.yyz.yyzsbackpack.compat.AccessoriesContainerAdapter;
import com.yyz.yyzsbackpack.item.BackpackItem;
import com.yyz.yyzsbackpack.item.BackpackMaterial;
import com.yyz.yyzsbackpack.neoforge.compat.curios.CuriosContainerAdapter;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.common.CuriosConfig;

@Mod(value="yyzsbackpack")
public final class BackpackNeoForge {
    public static final DeferredRegister.DataComponents DATA_COMPONENT = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"yyzsbackpack");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"yyzsbackpack");
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"yyzsbackpack");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> BACKPACK_TAB = TABS.register("backpack_tab", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)GOLD_BACKPACK.get())).title((Component)Component.translatable((String)"itemGroup.yyzsbackpack.title")).displayItems((context, entries) -> {
        entries.accept((ItemLike)WOOLEN_BACKPACK.get());
        entries.accept((ItemLike)STONE_BACKPACK.get());
        entries.accept((ItemLike)IRON_BACKPACK.get());
        entries.accept((ItemLike)GOLD_BACKPACK.get());
        entries.accept((ItemLike)DIAMOND_BACKPACK.get());
        entries.accept((ItemLike)NETHERITE_BACKPACK.get());
    }).build());
    public static final DeferredHolder<Item, Item> NETHERITE_BACKPACK = ITEMS.register("netherite_backpack", () -> new BackpackItem(BackpackMaterial.NETHERITE, new Item.Properties().stacksTo(1).fireResistant()));
    public static final DeferredHolder<Item, Item> DIAMOND_BACKPACK = ITEMS.register("diamond_backpack", () -> new BackpackItem(BackpackMaterial.DIAMOND, new Item.Properties().stacksTo(1)));
    public static final DeferredHolder<Item, Item> GOLD_BACKPACK = ITEMS.register("gold_backpack", () -> new BackpackItem(BackpackMaterial.GOLD, new Item.Properties().stacksTo(1)));
    public static final DeferredHolder<Item, Item> IRON_BACKPACK = ITEMS.register("iron_backpack", () -> new BackpackItem(BackpackMaterial.IRON, new Item.Properties().stacksTo(1)));
    public static final DeferredHolder<Item, Item> STONE_BACKPACK = ITEMS.register("stone_backpack", () -> new BackpackItem(BackpackMaterial.STONE, new Item.Properties().stacksTo(1)));
    public static final DeferredHolder<Item, Item> WOOLEN_BACKPACK = ITEMS.register("woolen_backpack", () -> new BackpackItem(BackpackMaterial.WOOLEN, new Item.Properties().stacksTo(1)));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<List<ItemStack>>> BACKPACK_ITEMS_COMPONENT = DATA_COMPONENT.registerComponentType("backpack_items", builder -> builder.persistent(Codec.list((Codec)ItemStack.OPTIONAL_CODEC)));

    public BackpackNeoForge(IEventBus modEventBus) {
        ITEMS.register(modEventBus);
        TABS.register(modEventBus);
        DATA_COMPONENT.register(modEventBus);
        Backpack.init();
    }

    public static ItemStack getEquipped(Player player) {
        if (!Backpack.getConfig().force_slot) {
            AccessoriesCapability capability;
            Optional backpackSlot;
            Optional curiosHandler;
            if (BackpackHelper.isModLoaded("curios") && (curiosHandler = CuriosApi.getCuriosInventory((LivingEntity)player)).isPresent() && (backpackSlot = ((ICuriosItemHandler)curiosHandler.get()).findFirstCurio(stack -> stack.getItem() instanceof BackpackItem)).isPresent()) {
                return ((SlotResult)backpackSlot.get()).stack();
            }
            if (BackpackHelper.isModLoaded("accessories") && !BackpackHelper.isModLoaded("curios") && (capability = AccessoriesCapability.get((LivingEntity)player)) != null) {
                Map containers = capability.getContainers();
                for (AccessoriesContainer container : containers.values()) {
                    ExpandedSimpleContainer accessoriesContainer = container.getAccessories();
                    for (int i = 0; i < accessoriesContainer.getContainerSize(); ++i) {
                        ItemStack stack2 = accessoriesContainer.getItem(i);
                        if (!(stack2.getItem() instanceof BackpackItem)) continue;
                        return stack2;
                    }
                }
            }
        }
        return player.getInventory().getItem(90);
    }

    public static Container getContainer(Player player) {
        if (!Backpack.getConfig().force_slot) {
            AccessoriesCapability capability;
            Optional backpackSlot;
            Optional curiosHandler;
            if (BackpackHelper.isModLoaded("curios") && (curiosHandler = CuriosApi.getCuriosInventory((LivingEntity)player)).isPresent() && (backpackSlot = ((ICuriosItemHandler)curiosHandler.get()).findFirstCurio(stack -> stack.getItem() instanceof BackpackItem)).isPresent()) {
                SlotContext slotContext = ((SlotResult)backpackSlot.get()).slotContext();
                String slotId = slotContext.identifier();
                int slotIndex = slotContext.index();
                Optional stacksHandler = ((ICuriosItemHandler)curiosHandler.get()).getStacksHandler(slotId);
                if (stacksHandler.isPresent()) {
                    return new CuriosContainerAdapter(((ICurioStacksHandler)stacksHandler.get()).getStacks(), slotIndex);
                }
            }
            if (BackpackHelper.isModLoaded("accessories") && !BackpackHelper.isModLoaded("curios") && (capability = AccessoriesCapability.get((LivingEntity)player)) != null) {
                Map containers = capability.getContainers();
                for (AccessoriesContainer container : containers.values()) {
                    ExpandedSimpleContainer accessoriesContainer = container.getAccessories();
                    for (int i = 0; i < accessoriesContainer.getContainerSize(); ++i) {
                        ItemStack stack2 = accessoriesContainer.getItem(i);
                        if (!(stack2.getItem() instanceof BackpackItem)) continue;
                        return new AccessoriesContainerAdapter((Container)accessoriesContainer, i);
                    }
                }
            }
        }
        return player.getInventory();
    }

    public static int getIndex(Player player) {
        if (!Backpack.getConfig().force_slot) {
            Container container;
            Container container2;
            Optional backpackSlot;
            Optional curiosHandler;
            if (BackpackHelper.isModLoaded("curios") && (curiosHandler = CuriosApi.getCuriosInventory((LivingEntity)player)).isPresent() && (backpackSlot = ((ICuriosItemHandler)curiosHandler.get()).findFirstCurio(stack -> stack.getItem() instanceof BackpackItem)).isPresent() && (container2 = BackpackNeoForge.getContainer(player)) instanceof CuriosContainerAdapter) {
                return ((CuriosContainerAdapter)container2).getBackpackSlotIndex();
            }
            if (BackpackHelper.isModLoaded("accessories") && !BackpackHelper.isModLoaded("curios") && (container = BackpackNeoForge.getContainer(player)) instanceof AccessoriesContainerAdapter) {
                return ((AccessoriesContainerAdapter)container).getBackpackSlotIndex();
            }
        }
        return 90;
    }

    public static boolean getEmptyRule(Player player) {
        return !BackpackHelper.isModLoaded("curios") || player.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY) || CuriosConfig.SERVER.keepCurios.get() != CuriosConfig.KeepCurios.ON;
    }
}

