/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.mixin;

import com.yyz.yyzsbackpack.BackpackPlatform;
import com.yyz.yyzsbackpack.base.BackpackMenu;
import com.yyz.yyzsbackpack.base.BackpackScreen;
import com.yyz.yyzsbackpack.client.BackpackRenderer;
import com.yyz.yyzsbackpack.item.BackpackItem;
import com.yyz.yyzsbackpack.util.BackpackHelper;
import com.yyz.yyzsbackpack.util.SlotManager;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_465.class})
public abstract class AbstractContainerScreenMixin<T extends class_1703>
extends class_437
implements BackpackScreen {
    @Shadow
    protected int field_2792;
    @Shadow
    protected int field_2779;
    @Shadow
    protected int field_2776;
    @Shadow
    protected int field_2800;
    @Shadow
    @Final
    protected T field_2797;
    @Shadow
    @Nullable
    protected class_1735 field_2787;
    @Shadow
    protected boolean field_2794;
    @Unique
    private class_1661 inventory;
    @Unique
    private boolean shouldRenderBackpack = false;
    @Unique
    private boolean previousBackpackState = false;
    @Unique
    private class_1735 lastShiftHoveredSlot;
    @Unique
    private boolean shiftPressed;
    @Unique
    private int type;

    @Shadow
    protected abstract boolean method_2381(double var1, double var3, int var5, int var6, int var7);

    @Shadow
    protected abstract void method_2383(class_1735 var1, int var2, int var3, class_1713 var4);

    protected AbstractContainerScreenMixin(class_2561 title) {
        super(title);
    }

    @Inject(method={"renderBackground"}, at={@At(value="RETURN")})
    private void onRenderBackground(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        BackpackRenderer.renderEquippedBackpackBackground(context, this.field_2776, this.field_2800, this.field_2792, this.field_2779, this.inventory, this.shouldRenderBackpack, (BackpackMenu)this.field_2797);
        BackpackRenderer.renderBackpackPreview(context, this.field_22787, this.field_2797, this.field_2787, this.field_2776, this.field_2800, this.field_2792, this.field_2779);
    }

    @ModifyConstant(method={"checkHotbarMouseClicked"}, constant={@Constant(intValue=40)})
    private int adjustOffhandSlotPosition(int original) {
        return 40 + BackpackHelper.getSlotIndexOffset();
    }

    @ModifyConstant(method={"checkHotbarKeyPressed"}, constant={@Constant(intValue=40)})
    private int adjustOffhandSlotPositionHotbar(int original) {
        return 40 + BackpackHelper.getSlotIndexOffset();
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void checkBackpackStateChange(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        boolean currentState = BackpackHelper.shouldRenderBackpack(this.field_2797, this.inventory);
        if (currentState != this.previousBackpackState) {
            this.shouldRenderBackpack = currentState;
            this.previousBackpackState = currentState;
            this.method_41843();
        }
    }

    @Redirect(method={"mouseClicked"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;hasClickedOutside(DDIII)Z"))
    private boolean handleMouseClicked(class_465<?> instance, double mouseX, double mouseY, int left, int top, int button) {
        return this.field_2797 instanceof BackpackMenu ? BackpackHelper.isClickOutsideExtendedBounds(this.inventory, this.method_2381(mouseX, mouseY, this.field_2776, this.field_2800, button), mouseX, mouseY, this.field_2776, this.field_2800, this.field_2792, this.field_2779, this.shouldRenderBackpack, (BackpackMenu)this.field_2797) : this.method_2381(mouseX, mouseY, this.field_2776, this.field_2800, button);
    }

    @Redirect(method={"mouseReleased"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;hasClickedOutside(DDIII)Z"))
    private boolean handleMouseReleased(class_465<?> instance, double mouseX, double mouseY, int left, int top, int button) {
        return this.field_2797 instanceof BackpackMenu ? BackpackHelper.isClickOutsideExtendedBounds(this.inventory, this.method_2381(mouseX, mouseY, this.field_2776, this.field_2800, button), mouseX, mouseY, this.field_2776, this.field_2800, this.field_2792, this.field_2779, this.shouldRenderBackpack, (BackpackMenu)this.field_2797) : this.method_2381(mouseX, mouseY, this.field_2776, this.field_2800, button);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void initializeFields(class_1703 abstractContainerMenu, class_1661 inventory, class_2561 component, CallbackInfo ci) {
        this.inventory = inventory;
        this.previousBackpackState = this.shouldRenderBackpack = BackpackHelper.shouldRenderBackpack(this.field_2797, this.inventory);
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void updateBackpackSlotsPositionBeforeRender(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        SlotManager.updateBackpackSlotPositions(this, this.field_2797, this.inventory, this.field_2779);
    }

    @Override
    public List<class_768> getBackpackExclusionZones() {
        int xOffset = ((BackpackMenu)this.field_2797).getBackpackGuiX();
        int yOffset = ((BackpackMenu)this.field_2797).getBackpackGuiY();
        if (!this.shouldRenderBackpack) {
            return Collections.emptyList();
        }
        boolean columns = false;
        int baseWidth = 256;
        int height = 256;
        class_1799 backpackStack = BackpackPlatform.getEquipped(this.inventory.field_7546);
        class_1792 class_17922 = backpackStack.method_7909();
        if (class_17922 instanceof BackpackItem) {
            BackpackItem backpack = (BackpackItem)class_17922;
            baseWidth = backpack.getBackpackType().guiWidth();
            height = backpack.getBackpackType().guiHeight();
        }
        int x = this.field_2776 - baseWidth - 1 + xOffset;
        int y = this.field_2800 + (this.field_2779 - height) / 2 + yOffset;
        int actualWidth = baseWidth;
        if (xOffset != 0) {
            actualWidth = xOffset > 0 ? (actualWidth += xOffset) : (actualWidth -= xOffset);
            actualWidth = Math.max(actualWidth, baseWidth);
        }
        return Collections.singletonList(new class_768(x, y, actualWidth, height));
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")})
    private void onKeyPressed(int i, int j, int k, CallbackInfoReturnable<Boolean> cir) {
        if (class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)82) && this.field_2797.method_34255().method_7960() && this.field_2787 != null) {
            this.method_2383(this.field_2787, this.field_2787.field_7874, 2, class_1713.field_7794);
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")})
    private void onKeyPressed(double d, double e, int i, CallbackInfoReturnable<Boolean> cir) {
        if (class_437.method_25442() && this.field_2797.method_34255().method_7960()) {
            this.shiftPressed = true;
            this.type = i;
        }
    }

    @Inject(method={"mouseReleased"}, at={@At(value="HEAD")})
    private void onKeyReleased(double d, double e, int i, CallbackInfoReturnable<Boolean> cir) {
        if (this.shiftPressed) {
            this.shiftPressed = false;
            this.lastShiftHoveredSlot = null;
        }
    }

    @Inject(method={"mouseDragged"}, at={@At(value="TAIL")})
    private void onMouseMoved(double d, double e, int i, double f, double g, CallbackInfoReturnable<Boolean> cir) {
        if (this.shiftPressed && !this.field_2794 && this.field_2787 != null && this.field_2787 != this.lastShiftHoveredSlot && this.field_2787.method_7681()) {
            this.method_2383(this.field_2787, this.field_2787.field_7874, this.type, class_1713.field_7794);
            this.lastShiftHoveredSlot = this.field_2787;
        }
    }
}

