/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.util;

import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackPlatform;
import com.yyz.yyzsbackpack.base.BackpackMenu;
import com.yyz.yyzsbackpack.data.BackpackMaterialManager;
import com.yyz.yyzsbackpack.item.BackpackItem;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1291;
import net.minecraft.class_151;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class BackpackHelper {
    public static boolean isTrinketModLoaded() {
        return BackpackPlatform.isModLoaded("trinkets") || BackpackPlatform.isModLoaded("curios") || BackpackPlatform.isModLoaded("accessories");
    }

    public static int getMaxBackpackSize() {
        return BackpackMaterialManager.getMaxSize();
    }

    public static int getSlotIndexOffset() {
        return BackpackHelper.getMaxBackpackSize() + 1;
    }

    public static boolean shouldRenderBackpack(class_1703 menu, class_1661 inventory) {
        if (inventory != null && ((BackpackMenu)menu).isBackpackVisible()) {
            class_1799 backpackStack = BackpackPlatform.getEquipped(inventory.field_7546);
            return backpackStack.method_7909() instanceof BackpackItem;
        }
        return false;
    }

    public static int getBackpackSize(class_1657 player) {
        class_1799 backpackStack = BackpackPlatform.getEquipped(player);
        class_1792 class_17922 = backpackStack.method_7909();
        if (class_17922 instanceof BackpackItem) {
            BackpackItem backpackItem = (BackpackItem)class_17922;
            return 36 + backpackItem.getBackpackType().getSize();
        }
        return 36;
    }

    private static Set<class_2960> convertStringSetToIdentifierSet(Set<String> stringSet) {
        return stringSet.stream().map(s -> {
            try {
                return class_2960.method_12829((String)s);
            }
            catch (class_151 e) {
                System.err.println("Invalid Identifier: " + s);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static boolean isItemBlacklisted(class_1792 item) {
        class_2960 id = class_7923.field_41178.method_10221((Object)item);
        return BackpackHelper.convertStringSetToIdentifierSet(Backpack.getConfig().restricted_items).contains(id);
    }

    public static class_6880<class_1291> getEffectHolder(String effectId) {
        class_2960 location = class_2960.method_12829((String)effectId);
        if (location == null) {
            return null;
        }
        Optional holder = class_7923.field_41174.method_46746(class_5321.method_29179((class_5321)class_7923.field_41174.method_46765(), (class_2960)location));
        return holder.orElse(null);
    }

    public static boolean isClickOutsideExtendedBounds(class_1661 inventory, boolean outsideOriginalBounds, double mouseX, double mouseY, int left, int top, int backgroundWidth, int backgroundHeight, boolean shouldRenderBackpackExtension, BackpackMenu renderCondition) {
        boolean inBackpackArea = false;
        if (shouldRenderBackpackExtension) {
            int width = 256;
            int height = 256;
            class_1799 backpackStack = BackpackPlatform.getEquipped(inventory.field_7546);
            class_1792 class_17922 = backpackStack.method_7909();
            if (class_17922 instanceof BackpackItem) {
                BackpackItem backpack = (BackpackItem)class_17922;
                width = backpack.getBackpackType().guiWidth();
                height = backpack.getBackpackType().guiHeight();
            }
            int backpackX = left - width - 1 + renderCondition.getBackpackGuiX();
            int backpackY = top + (backgroundHeight - height) / 2 + renderCondition.getBackpackGuiY();
            int backpackHeight = height;
            inBackpackArea = mouseX >= (double)backpackX && mouseX < (double)(backpackX + width) && mouseY >= (double)backpackY && mouseY < (double)(backpackY + backpackHeight);
        }
        return outsideOriginalBounds && !inBackpackArea;
    }
}

