/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.base;

import com.yyz.yyzsbackpack.item.BackpackItem;
import com.yyz.yyzsbackpack.util.BackpackStorage;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class BackpackEquipSlot
extends Slot {
    private final Container inventory;

    public BackpackEquipSlot(Container container, int i, int j, int k) {
        super(container, i, j, k);
        this.inventory = container;
    }

    public boolean mayPlace(ItemStack stack) {
        return stack.getItem() instanceof BackpackItem;
    }

    public void onTake(Player player, ItemStack backpackStack) {
        if (backpackStack.getItem() instanceof BackpackItem) {
            BackpackStorage.saveBackpackContents(this.inventory, backpackStack, true);
        }
        super.onTake(player, backpackStack);
    }

    public void setByPlayer(ItemStack newBackpackStack) {
        ItemStack oldBackpackStack = this.getItem();
        if (!oldBackpackStack.isEmpty() && oldBackpackStack.getItem() instanceof BackpackItem) {
            BackpackStorage.saveBackpackContents(this.inventory, oldBackpackStack, true);
        }
        super.setByPlayer(newBackpackStack);
        if (!newBackpackStack.isEmpty() && newBackpackStack.getItem() instanceof BackpackItem) {
            BackpackStorage.restoreBackpackContents(this.inventory, newBackpackStack);
        }
    }

    public ResourceLocation getNoItemIcon() {
        return ResourceLocation.fromNamespaceAndPath((String)"yyzsbackpack", (String)"container/slot/backslot");
    }
}

