/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackPlatform;
import com.yyz.yyzsbackpack.base.BackpackMenu;
import com.yyz.yyzsbackpack.item.BackpackItem;
import com.yyz.yyzsbackpack.util.BackpackHelper;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class BackpackRenderer {
    public static void renderEquipSlotBackground(InventoryMenu menu, GuiGraphics guiGraphics, int x, int y) {
        if (BackpackHelper.isTrinketModLoaded() && !Backpack.getConfig().use_dedicated_slot) {
            return;
        }
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, ResourceLocation.fromNamespaceAndPath((String)"yyzsbackpack", (String)"textures/gui/slot.png"), x + ((BackpackMenu)menu).getBackpackEquipSlotX(), y + ((BackpackMenu)menu).getBackpackEquipSlotY(), 0.0f, 0.0f, 18, 18, 18, 18);
    }

    public static void renderEquippedBackpackBackground(GuiGraphics context, int x, int y, int backgroundWidth, int backgroundHeight, Inventory inventory, boolean shouldRenderBackpack, BackpackMenu renderCondition) {
        if (!shouldRenderBackpack) {
            return;
        }
        int width = 256;
        int height = 256;
        ResourceLocation texture = null;
        ItemStack stack = BackpackPlatform.getEquipped(inventory.player);
        Item item = stack.getItem();
        if (item instanceof BackpackItem) {
            BackpackItem backpackItem = (BackpackItem)item;
            texture = backpackItem.getBackpackType().getGuiTexture();
            width = backpackItem.getBackpackType().guiWidth();
            height = backpackItem.getBackpackType().guiHeight();
        }
        if (texture == null) {
            return;
        }
        int left = x - width - 1 + renderCondition.getBackpackGuiX();
        int top = y + (backgroundHeight - height) / 2 + renderCondition.getBackpackGuiY();
        context.blit(RenderPipelines.GUI_TEXTURED, texture, left, top, 0.0f, 0.0f, width, height, width, height);
    }

    public static void renderBackpackPreview(GuiGraphics guiGraphics, Minecraft minecraft, AbstractContainerMenu menu, @Nullable Slot hoveredSlot, int leftPos, int topPos, int imageWidth, int imageHeight) {
        boolean requireKey;
        ((BackpackMenu)menu).setPreviewVisible(false);
        switch (Backpack.getConfig().tooltip_modifier.toLowerCase()) {
            case "shift": {
                requireKey = InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)340) || InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)344);
                break;
            }
            case "alt": {
                requireKey = InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)342) || InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)346);
                break;
            }
            case "ctrl": {
                requireKey = InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)341) || InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)345);
                break;
            }
            case "none": {
                requireKey = true;
                break;
            }
            default: {
                if (!InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)340) && !InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)344)) {
                    return;
                }
                return;
            }
        }
        if (!requireKey) {
            return;
        }
        if (hoveredSlot == null || !menu.getCarried().isEmpty()) {
            return;
        }
        ItemStack backpackStack = hoveredSlot.getItem();
        Item item = backpackStack.getItem();
        if (!(item instanceof BackpackItem)) {
            return;
        }
        BackpackItem backpackItem = (BackpackItem)item;
        BackpackRenderer.renderPreviewBackpackBackground(guiGraphics, backpackStack, leftPos, topPos, imageWidth, imageHeight, (BackpackMenu)menu);
        ((BackpackMenu)menu).setPreviewVisible(true);
        List backpackItems = (List)backpackStack.get(BackpackPlatform.getBackpackItemsComponent());
        if (backpackItems == null) {
            return;
        }
        int baseHeight = imageHeight;
        int columns = backpackItem.getBackpackType().getColumns();
        int rows = backpackItem.getBackpackType().getRows();
        int startX = -25 - (columns - 1) * 18;
        int startY = (baseHeight - 166) / 2 + 3;
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                int slotIndex = row * columns + column;
                if (slotIndex >= backpackItems.size()) continue;
                int x = leftPos + startX + column * 18;
                int y = topPos + startY + row * 18;
                ItemStack stack = (ItemStack)backpackItems.get(slotIndex);
                guiGraphics.renderItem(stack, x, y);
                guiGraphics.renderItemDecorations(minecraft.font, stack, x, y);
            }
        }
    }

    public static void renderPreviewBackpackBackground(GuiGraphics context, ItemStack stack, int x, int y, int backgroundWidth, int backgroundHeight, BackpackMenu renderCondition) {
        int width = 256;
        int height = 256;
        ResourceLocation texture = null;
        Item item = stack.getItem();
        if (item instanceof BackpackItem) {
            BackpackItem backpackItem = (BackpackItem)item;
            texture = backpackItem.getBackpackType().getGuiTexture();
            width = backpackItem.getBackpackType().guiWidth();
            height = backpackItem.getBackpackType().guiHeight();
        }
        if (texture == null) {
            return;
        }
        int left = x - width - 1 + renderCondition.getBackpackGuiX();
        int top = y + (backgroundHeight - 174) / 2 + renderCondition.getBackpackGuiY();
        context.blit(RenderPipelines.GUI_TEXTURED, texture, left, top, 0.0f, 0.0f, width, height, width, height);
    }
}

