/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackPlatform;
import com.yyz.yyzsbackpack.base.BackpackRenderState;
import com.yyz.yyzsbackpack.item.BackpackItem;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;

public class SimplifiedBackpackFeatureRenderer
extends RenderLayer<AvatarRenderState, PlayerModel> {
    private final ModelPart backpack = this.createBackpackModel();
    private final ModelPart backpack_overlay = this.createBackpackOverlayModel();

    public SimplifiedBackpackFeatureRenderer(RenderLayerParent<AvatarRenderState, PlayerModel> renderLayerParent) {
        super(renderLayerParent);
    }

    private ModelPart createBackpackModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition leather_backpack = partdefinition.addOrReplaceChild("leather_backpack", CubeListBuilder.create().texOffs(0, 8).addBox(-4.0f, -8.0f, -3.0f, 8.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(26, 8).mirror().addBox(-4.0f, -8.0f, 1.0f, 2.0f, 11.0f, 5.0f, new CubeDeformation(0.1f)).mirror(false).texOffs(26, 8).mirror().addBox(2.0f, -8.0f, 1.0f, 2.0f, 11.0f, 5.0f, new CubeDeformation(0.1f)).mirror(false).texOffs(4, 0).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.75f, (float)4.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition top = leather_backpack.addOrReplaceChild("top", CubeListBuilder.create().texOffs(0, 20).addBox(-4.0f, -1.0f, -4.0f, 9.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)-7.5f, (float)0.5f));
        return meshdefinition.getRoot().bake(64, 64).getChild("leather_backpack");
    }

    private ModelPart createBackpackOverlayModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition leather_backpack_overlay = partdefinition.addOrReplaceChild("leather_backpack_overlay", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition cube_r2 = leather_backpack_overlay.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(4, 29).addBox(-4.5f, -2.0f, 0.0f, 9.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-17.75f, (float)7.25f, (float)0.1309f, (float)3.1416f, (float)0.0f));
        return meshdefinition.getRoot().bake(64, 64).getChild("leather_backpack_overlay");
    }

    public void submit(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int i, AvatarRenderState entityRenderState, float f, float g) {
        Avatar player = ((BackpackRenderState)entityRenderState).getAbstractClientPlayer();
        if (this.shouldRender(player)) {
            int j = DyedItemColor.getOrDefault((ItemStack)BackpackPlatform.getEquippedL((LivingEntity)player), (int)-6265536);
            poseStack.pushPose();
            ((PlayerModel)this.getParentModel()).body.translateAndRotate(poseStack);
            poseStack.scale(0.8f, 0.8f, 0.8f);
            submitNodeCollector.submitModelPart(this.backpack, poseStack, RenderType.entityCutout((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"yyzsbackpack", (String)"textures/backpack/leather_backpack.png")), i, OverlayTexture.NO_OVERLAY, (TextureAtlasSprite)null, j, null);
            submitNodeCollector.submitModelPart(this.backpack_overlay, poseStack, RenderType.entityCutout((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"yyzsbackpack", (String)"textures/backpack/leather_backpack_overlay.png")), i, OverlayTexture.NO_OVERLAY, (TextureAtlasSprite)null);
            poseStack.popPose();
        }
    }

    private void renderBackpack(PoseStack matrices, MultiBufferSource vertexConsumers, Player player, int light) {
        if (BackpackPlatform.getEquipped(player).getItem() instanceof BackpackItem) {
            int j = DyedItemColor.getOrDefault((ItemStack)BackpackPlatform.getEquipped(player), (int)-6265536);
            matrices.pushPose();
            ((PlayerModel)this.getParentModel()).body.translateAndRotate(matrices);
            VertexConsumer vertexConsumer = vertexConsumers.getBuffer(RenderType.entityCutout((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"yyzsbackpack", (String)"textures/backpack/leather_backpack.png")));
            this.backpack.render(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY, j);
            VertexConsumer overlay_vertexConsumer = vertexConsumers.getBuffer(RenderType.entityCutout((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"yyzsbackpack", (String)"textures/backpack/leather_backpack_overlay.png")));
            this.backpack_overlay.render(matrices, overlay_vertexConsumer, light, OverlayTexture.NO_OVERLAY);
            matrices.popPose();
        }
    }

    private boolean shouldRender(Avatar player) {
        return BackpackPlatform.getEquippedL((LivingEntity)player).getItem() instanceof BackpackItem && Backpack.getConfig().render_backpack_model && Backpack.getConfig().backpack_model_style.equals("simplified");
    }
}

