/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.mixin;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.yyz.yyzsbackpack.BackpackPlatform;
import com.yyz.yyzsbackpack.base.BackpackMenu;
import com.yyz.yyzsbackpack.base.BackpackScreen;
import com.yyz.yyzsbackpack.client.BackpackRenderer;
import com.yyz.yyzsbackpack.item.BackpackItem;
import com.yyz.yyzsbackpack.util.BackpackHelper;
import com.yyz.yyzsbackpack.util.SlotManager;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin<T extends AbstractContainerMenu>
extends Screen
implements BackpackScreen {
    @Shadow
    protected int imageWidth;
    @Shadow
    protected int imageHeight;
    @Shadow
    protected int leftPos;
    @Shadow
    protected int topPos;
    @Shadow
    @Final
    protected T menu;
    @Shadow
    @Nullable
    protected Slot hoveredSlot;
    @Shadow
    protected boolean isQuickCrafting;
    @Unique
    private Inventory inventory;
    @Unique
    private boolean shouldRenderBackpack = false;
    @Unique
    private boolean previousBackpackState = false;
    @Unique
    private Slot lastShiftHoveredSlot;
    @Unique
    private boolean shiftPressed;
    @Unique
    private int type;

    @Shadow
    protected abstract void slotClicked(Slot var1, int var2, int var3, ClickType var4);

    @Shadow
    protected abstract boolean hasClickedOutside(double var1, double var3, int var5, int var6);

    protected AbstractContainerScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"renderBackground(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="RETURN")})
    private void onRenderBackground(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        BackpackRenderer.renderEquippedBackpackBackground(context, this.leftPos, this.topPos, this.imageWidth, this.imageHeight, this.inventory, this.shouldRenderBackpack, (BackpackMenu)this.menu);
        BackpackRenderer.renderBackpackPreview(context, this.minecraft, this.menu, this.hoveredSlot, this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
    }

    @ModifyConstant(method={"checkHotbarMouseClicked(Lnet/minecraft/client/input/MouseButtonEvent;)V"}, constant={@Constant(intValue=40)})
    private int adjustOffhandSlotPosition(int original) {
        return 40 + BackpackHelper.getSlotIndexOffset();
    }

    @ModifyConstant(method={"checkHotbarKeyPressed(Lnet/minecraft/client/input/KeyEvent;)Z"}, constant={@Constant(intValue=40)})
    private int adjustOffhandSlotPositionHotbar(int original) {
        return 40 + BackpackHelper.getSlotIndexOffset();
    }

    @Inject(method={"renderContents(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="HEAD")})
    private void checkBackpackStateChange(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        boolean currentState = BackpackHelper.shouldRenderBackpack(this.menu, this.inventory);
        if (currentState != this.previousBackpackState) {
            this.shouldRenderBackpack = currentState;
            this.previousBackpackState = currentState;
            this.rebuildWidgets();
        }
    }

    @Redirect(method={"mouseClicked(Lnet/minecraft/client/input/MouseButtonEvent;Z)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;hasClickedOutside(DDII)Z"))
    private boolean handleMouseClicked(AbstractContainerScreen<?> instance, double mouseX, double mouseY, int left, int top) {
        return this.menu instanceof BackpackMenu ? BackpackHelper.isClickOutsideExtendedBounds(this.inventory, this.hasClickedOutside(mouseX, mouseY, this.leftPos, this.topPos), mouseX, mouseY, this.leftPos, this.topPos, this.imageWidth, this.imageHeight, this.shouldRenderBackpack, (BackpackMenu)this.menu) : this.hasClickedOutside(mouseX, mouseY, this.leftPos, this.topPos);
    }

    @Redirect(method={"mouseReleased(Lnet/minecraft/client/input/MouseButtonEvent;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;hasClickedOutside(DDII)Z"))
    private boolean handleMouseReleased(AbstractContainerScreen<?> instance, double mouseX, double mouseY, int left, int top) {
        return this.menu instanceof BackpackMenu ? BackpackHelper.isClickOutsideExtendedBounds(this.inventory, this.hasClickedOutside(mouseX, mouseY, this.leftPos, this.topPos), mouseX, mouseY, this.leftPos, this.topPos, this.imageWidth, this.imageHeight, this.shouldRenderBackpack, (BackpackMenu)this.menu) : this.hasClickedOutside(mouseX, mouseY, this.leftPos, this.topPos);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/inventory/AbstractContainerMenu;Lnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/network/chat/Component;)V"}, at={@At(value="TAIL")})
    private void initializeFields(AbstractContainerMenu abstractContainerMenu, Inventory inventory, Component component, CallbackInfo ci) {
        this.inventory = inventory;
        this.previousBackpackState = this.shouldRenderBackpack = BackpackHelper.shouldRenderBackpack(this.menu, this.inventory);
    }

    @Inject(method={"renderContents(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="HEAD")})
    private void updateBackpackSlotsPositionBeforeRender(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        SlotManager.updateBackpackSlotPositions(this, this.menu, this.inventory, this.imageHeight);
    }

    @Override
    public List<Rect2i> getBackpackExclusionZones() {
        int xOffset = ((BackpackMenu)this.menu).getBackpackGuiX();
        int yOffset = ((BackpackMenu)this.menu).getBackpackGuiY();
        if (!this.shouldRenderBackpack) {
            return Collections.emptyList();
        }
        boolean columns = false;
        int baseWidth = 256;
        int height = 256;
        ItemStack backpackStack = BackpackPlatform.getEquipped(this.inventory.player);
        Item item = backpackStack.getItem();
        if (item instanceof BackpackItem) {
            BackpackItem backpack = (BackpackItem)item;
            baseWidth = backpack.getBackpackType().guiWidth();
            height = backpack.getBackpackType().guiHeight();
        }
        int x = this.leftPos - baseWidth - 1 + xOffset;
        int y = this.topPos + (this.imageHeight - height) / 2 + yOffset;
        int actualWidth = baseWidth;
        if (xOffset != 0) {
            actualWidth = xOffset > 0 ? (actualWidth += xOffset) : (actualWidth -= xOffset);
            actualWidth = Math.max(actualWidth, baseWidth);
        }
        return Collections.singletonList(new Rect2i(x, y, actualWidth, height));
    }

    @Inject(method={"keyPressed(Lnet/minecraft/client/input/KeyEvent;)Z"}, at={@At(value="HEAD")})
    private void onKeyPressed(KeyEvent keyEvent, CallbackInfoReturnable<Boolean> cir) {
        if (InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)82) && this.menu.getCarried().isEmpty() && this.hoveredSlot != null) {
            this.slotClicked(this.hoveredSlot, this.hoveredSlot.index, 2, ClickType.QUICK_MOVE);
        }
    }

    @Inject(method={"mouseClicked(Lnet/minecraft/client/input/MouseButtonEvent;Z)Z"}, at={@At(value="HEAD")})
    private void onKeyPressed(MouseButtonEvent mouseButtonEvent, boolean bl, CallbackInfoReturnable<Boolean> cir) {
        if (mouseButtonEvent.hasShiftDown() && this.menu.getCarried().isEmpty()) {
            this.shiftPressed = true;
            this.type = mouseButtonEvent.button();
        }
    }

    @Inject(method={"mouseReleased(Lnet/minecraft/client/input/MouseButtonEvent;)Z"}, at={@At(value="HEAD")})
    private void onKeyReleased(MouseButtonEvent mouseButtonEvent, CallbackInfoReturnable<Boolean> cir) {
        if (this.shiftPressed) {
            this.shiftPressed = false;
            this.lastShiftHoveredSlot = null;
        }
    }

    @Inject(method={"mouseDragged(Lnet/minecraft/client/input/MouseButtonEvent;DD)Z"}, at={@At(value="TAIL")})
    private void onMouseMoved(MouseButtonEvent mouseButtonEvent, double d, double e, CallbackInfoReturnable<Boolean> cir) {
        if (this.shiftPressed && !this.isQuickCrafting && this.hoveredSlot != null && this.hoveredSlot != this.lastShiftHoveredSlot && this.hoveredSlot.hasItem()) {
            this.slotClicked(this.hoveredSlot, this.hoveredSlot.index, this.type, ClickType.QUICK_MOVE);
            this.lastShiftHoveredSlot = this.hoveredSlot;
        }
    }
}

