/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.mixin;

import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.util.BackpackHelper;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ItemEntity.class}, priority=999)
public class ItemEntityMixin {
    @Redirect(method={"playerTouch(Lnet/minecraft/world/entity/player/Player;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Inventory;add(Lnet/minecraft/world/item/ItemStack;)Z"))
    private boolean modifyFindSlotMatchingItem(Inventory inventory, ItemStack stack) {
        int i = inventory.getSlotWithRemainingSpace(stack);
        if (i >= 0 && i < BackpackHelper.getBackpackSize(inventory.player)) {
            return inventory.add(i, stack);
        }
        if (inventory.getFreeSlot() >= 36 && inventory.getFreeSlot() < 36 + BackpackHelper.getMaxBackpackSize()) {
            return !BackpackHelper.isItemBlacklisted(stack.getItem()) && (stack.getItem().canFitInsideContainerItems() || !Backpack.getConfig().restrict_container_items) && inventory.getFreeSlot() < BackpackHelper.getBackpackSize(inventory.player) && inventory.add(stack);
        }
        return inventory.add(stack);
    }
}

