/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.util;

import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackPlatform;
import com.yyz.yyzsbackpack.base.BackpackMenu;
import com.yyz.yyzsbackpack.data.BackpackMaterialManager;
import com.yyz.yyzsbackpack.item.BackpackItem;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BackpackHelper {
    public static boolean isTrinketModLoaded() {
        return BackpackPlatform.isModLoaded("trinkets") || BackpackPlatform.isModLoaded("curios") || BackpackPlatform.isModLoaded("accessories");
    }

    public static int getMaxBackpackSize() {
        return BackpackMaterialManager.getMaxSize();
    }

    public static int getSlotIndexOffset() {
        return BackpackHelper.getMaxBackpackSize() + 1;
    }

    public static boolean shouldRenderBackpack(AbstractContainerMenu menu, Inventory inventory) {
        if (inventory != null && ((BackpackMenu)menu).isBackpackVisible()) {
            ItemStack backpackStack = BackpackPlatform.getEquipped(inventory.player);
            return backpackStack.getItem() instanceof BackpackItem;
        }
        return false;
    }

    public static int getBackpackSize(Player player) {
        ItemStack backpackStack = BackpackPlatform.getEquipped(player);
        Item item = backpackStack.getItem();
        if (item instanceof BackpackItem) {
            BackpackItem backpackItem = (BackpackItem)item;
            return 36 + backpackItem.getBackpackType().getSize();
        }
        return 36;
    }

    private static Set<ResourceLocation> convertStringSetToIdentifierSet(Set<String> stringSet) {
        return stringSet.stream().map(s -> {
            try {
                return ResourceLocation.tryParse((String)s);
            }
            catch (ResourceLocationException e) {
                System.err.println("Invalid Identifier: " + s);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static boolean isItemBlacklisted(Item item) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
        return BackpackHelper.convertStringSetToIdentifierSet(Backpack.getConfig().restricted_items).contains(id);
    }

    public static Holder<MobEffect> getEffectHolder(String effectId) {
        ResourceLocation location = ResourceLocation.tryParse((String)effectId);
        if (location == null) {
            return null;
        }
        Optional holder = BuiltInRegistries.MOB_EFFECT.get(ResourceKey.create((ResourceKey)BuiltInRegistries.MOB_EFFECT.key(), (ResourceLocation)location));
        return holder.orElse(null);
    }

    public static boolean isClickOutsideExtendedBounds(Inventory inventory, boolean outsideOriginalBounds, double mouseX, double mouseY, int left, int top, int backgroundWidth, int backgroundHeight, boolean shouldRenderBackpackExtension, BackpackMenu renderCondition) {
        boolean inBackpackArea = false;
        if (shouldRenderBackpackExtension) {
            int width = 256;
            int height = 256;
            ItemStack backpackStack = BackpackPlatform.getEquipped(inventory.player);
            Item item = backpackStack.getItem();
            if (item instanceof BackpackItem) {
                BackpackItem backpack = (BackpackItem)item;
                width = backpack.getBackpackType().guiWidth();
                height = backpack.getBackpackType().guiHeight();
            }
            int backpackX = left - width - 1 + renderCondition.getBackpackGuiX();
            int backpackY = top + (backgroundHeight - height) / 2 + renderCondition.getBackpackGuiY();
            int backpackHeight = height;
            inBackpackArea = mouseX >= (double)backpackX && mouseX < (double)(backpackX + width) && mouseY >= (double)backpackY && mouseY < (double)(backpackY + backpackHeight);
        }
        return outsideOriginalBounds && !inBackpackArea;
    }
}

