/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.util;

import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackPlatform;
import com.yyz.yyzsbackpack.base.BackpackStorageSlot;
import com.yyz.yyzsbackpack.item.BackpackItem;
import com.yyz.yyzsbackpack.util.BackpackHelper;
import com.yyz.yyzsbackpack.util.BackpackStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class BackpackSorter {
    public static void sortInventorySlots(Player player, NonNullList<Slot> slots) {
        ArrayList<Slot> inventorySlots = new ArrayList<Slot>();
        for (Slot slot : slots) {
            int index;
            if (!(slot.container instanceof Inventory) || (index = slot.getContainerSlot()) < 9 || index >= 36) continue;
            inventorySlots.add(slot);
        }
        BackpackSorter.sortSlots(inventorySlots);
    }

    public static void sortBackpackSlots(Player player, NonNullList<Slot> slots) {
        ArrayList<Slot> backpackSlots = new ArrayList<Slot>();
        for (Slot slot : slots) {
            if (!(slot instanceof BackpackStorageSlot)) continue;
            backpackSlots.add(slot);
        }
        BackpackSorter.sortSlots(backpackSlots);
    }

    public static void sortContainerSlots(Player player, Container container, NonNullList<Slot> slots) {
        ArrayList<Slot> containerSlots = new ArrayList<Slot>();
        for (Slot slot : slots) {
            if (slot.container != container || slot.container instanceof Inventory) continue;
            containerSlots.add(slot);
        }
        BackpackSorter.sortSlots(containerSlots);
    }

    private static void sortSlots(List<Slot> slotsToSort) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Slot slot : slotsToSort) {
            if (slot.getItem().isEmpty()) continue;
            items.add(slot.getItem().copy());
            slot.set(ItemStack.EMPTY);
        }
        HashMap<ResourceLocation, List> groupedItems = new HashMap<ResourceLocation, List>();
        for (ItemStack stack : items) {
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
            groupedItems.computeIfAbsent(id, k -> new ArrayList()).add(stack);
        }
        ArrayList arrayList = new ArrayList(groupedItems.keySet());
        Collections.sort(arrayList);
        int slotIndex = 0;
        block2: for (ResourceLocation id : arrayList) {
            List stacks = (List)groupedItems.get(id);
            List<ItemStack> merged = BackpackSorter.mergeStacks(stacks);
            for (ItemStack stack : merged) {
                if (slotIndex >= slotsToSort.size()) continue block2;
                slotsToSort.get(slotIndex++).set(stack);
            }
        }
    }

    private static List<ItemStack> mergeStacks(List<ItemStack> stacks) {
        ArrayList<ItemStack> merged = new ArrayList<ItemStack>();
        if (stacks.isEmpty()) {
            return merged;
        }
        ItemStack current = stacks.get(0).copy();
        for (int i = 1; i < stacks.size(); ++i) {
            ItemStack next = stacks.get(i);
            if (ItemStack.isSameItemSameComponents((ItemStack)current, (ItemStack)next)) {
                int space = current.getMaxStackSize() - current.getCount();
                if (space > 0) {
                    int transfer = Math.min(space, next.getCount());
                    current.grow(transfer);
                    next.shrink(transfer);
                }
                if (next.getCount() <= 0) continue;
            }
            merged.add(current);
            current = next.copy();
        }
        merged.add(current);
        return merged;
    }

    public static void handleBackpackSwap(AbstractContainerMenu menu, NonNullList<Slot> slots, ItemStack carried, int slotIndex, int button, ClickType actionType, Player player) {
        if (slotIndex < 0 || slotIndex >= slots.size() || actionType != ClickType.PICKUP || ((Slot)slots.get(slotIndex)).getItem().getItem() instanceof BackpackItem || !Backpack.getConfig().quick_swap_backpack) {
            return;
        }
        if (!(menu.getSlot(slotIndex) instanceof BackpackStorageSlot)) {
            return;
        }
        ItemStack back = BackpackPlatform.getEquipped(player).copy();
        ItemStack stack = carried.copy();
        if (!(back.getItem() instanceof BackpackItem) || !(stack.getItem() instanceof BackpackItem)) {
            return;
        }
        BackpackStorage.saveBackpackContents((Container)player.getInventory(), back, true);
        BackpackStorage.restoreBackpackContents((Container)player.getInventory(), stack);
        Container container = BackpackPlatform.getContainer(player);
        container.setItem(BackpackPlatform.getIndex(player), stack);
        menu.setCarried(back);
    }

    public static ItemStack quickMoveToHotbar(AbstractContainerMenu menu, Player player, int slotIndex, NonNullList<Slot> slots) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)slots.get(slotIndex);
        int hotbarStart = -1;
        int hotbarEnd = -1;
        for (int idx = 0; idx < slots.size(); ++idx) {
            Slot s = (Slot)slots.get(idx);
            if (!(s.container instanceof Inventory) || s.getContainerSlot() < 0 || s.getContainerSlot() >= 9) continue;
            if (hotbarStart == -1) {
                hotbarStart = idx;
            }
            hotbarEnd = idx + 1;
        }
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            if (!menu.moveItemStackTo(slotStack, hotbarStart, hotbarEnd, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            slot.onTake(player, slotStack);
        }
        return itemStack;
    }

    public static ItemStack quickMoveToBackpack(AbstractContainerMenu menu, Player player, int slotIndex, NonNullList<Slot> slots) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            int backpackStart = -1;
            for (int i = 0; i < slots.size(); ++i) {
                if (!(slots.get(i) instanceof BackpackStorageSlot)) continue;
                backpackStart = i;
                break;
            }
            if (backpackStart == -1) {
                return ItemStack.EMPTY;
            }
            if (!menu.moveItemStackTo(slotStack, backpackStart, backpackStart + BackpackHelper.getMaxBackpackSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            slot.onTake(player, slotStack);
        }
        return itemStack;
    }

    public static void quickMoveTo(AbstractContainerMenu menu, NonNullList<Slot> slots, int i, int j, ClickType clickType, Player player, CallbackInfo ci) {
        if (clickType == ClickType.QUICK_MOVE && j == 1) {
            if (i < 0) {
                ci.cancel();
                return;
            }
            Slot slot = (Slot)slots.get(i);
            if (!slot.mayPickup(player)) {
                ci.cancel();
                return;
            }
            if (slot instanceof BackpackStorageSlot) {
                ItemStack itemStack = BackpackSorter.quickMoveToHotbar(menu, player, i, slots);
                while (!itemStack.isEmpty() && ItemStack.isSameItem((ItemStack)slot.getItem(), (ItemStack)itemStack)) {
                    itemStack = BackpackSorter.quickMoveToHotbar(menu, player, i, slots);
                }
                ci.cancel();
            } else {
                ItemStack itemStack = BackpackSorter.quickMoveToBackpack(menu, player, i, slots);
                while (!itemStack.isEmpty() && ItemStack.isSameItem((ItemStack)slot.getItem(), (ItemStack)itemStack)) {
                    itemStack = BackpackSorter.quickMoveToBackpack(menu, player, i, slots);
                }
                ci.cancel();
            }
        } else if (clickType == ClickType.QUICK_MOVE && j == 2) {
            boolean isContainerSlot;
            int slotIndexInPlayerInv;
            Slot hoveredSlot = (Slot)slots.get(i);
            boolean isInventorySlot = false;
            if (hoveredSlot.container instanceof Inventory && (slotIndexInPlayerInv = hoveredSlot.getContainerSlot()) >= 9 && slotIndexInPlayerInv < 36) {
                isInventorySlot = true;
            }
            boolean isBackpackSlot = hoveredSlot instanceof BackpackStorageSlot;
            boolean bl = isContainerSlot = !isInventorySlot && !isBackpackSlot && hoveredSlot.container != player.getInventory();
            if (!(isInventorySlot || isBackpackSlot || isContainerSlot)) {
                return;
            }
            if (isInventorySlot) {
                BackpackSorter.sortInventorySlots(player, slots);
            } else if (isBackpackSlot) {
                BackpackSorter.sortBackpackSlots(player, slots);
            } else {
                BackpackSorter.sortContainerSlots(player, hoveredSlot.container, slots);
            }
        }
    }
}

