/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackPlatform;
import com.yyz.yyzsbackpack.base.BackpackMenu;
import com.yyz.yyzsbackpack.item.BackpackItem;
import com.yyz.yyzsbackpack.util.BackpackHelper;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class BackpackRenderer {
    public static final ResourceLocation BACKPACK_TEXTURE = new ResourceLocation("yyzsbackpack", "textures/gui/backpack.png");

    public static void renderEquipSlotBackground(InventoryMenu menu, GuiGraphics guiGraphics, int x, int y) {
        if (BackpackHelper.isTrinketModLoaded() && !Backpack.getConfig().use_dedicated_slot) {
            return;
        }
        guiGraphics.m_280163_(new ResourceLocation("yyzsbackpack", "textures/gui//slot.png"), x + ((BackpackMenu)menu).getBackpackEquipSlotX(), y + ((BackpackMenu)menu).getBackpackEquipSlotY(), 0.0f, 0.0f, 18, 18, 18, 18);
    }

    public static void renderEquippedBackpackBackground(GuiGraphics context, int x, int y, int backgroundWidth, int backgroundHeight, Inventory inventory, boolean shouldRenderBackpack, BackpackMenu renderCondition) {
        RenderSystem.enableBlend();
        if (!shouldRenderBackpack) {
            return;
        }
        int width = 256;
        int height = 256;
        ResourceLocation texture = null;
        ItemStack stack = BackpackPlatform.getEquipped(inventory.f_35978_);
        Item item = stack.m_41720_();
        if (item instanceof BackpackItem) {
            BackpackItem backpackItem = (BackpackItem)item;
            texture = backpackItem.getBackpackType().getGuiTexture();
            width = backpackItem.getBackpackType().guiWidth();
            height = backpackItem.getBackpackType().guiHeight();
        }
        if (texture == null) {
            return;
        }
        int left = x - width - 1 + renderCondition.getBackpackGuiX();
        int top = y + (backgroundHeight - height) / 2 + renderCondition.getBackpackGuiY();
        context.m_280163_(texture, left, top, 0.0f, 0.0f, width, height, width, height);
        RenderSystem.disableBlend();
    }

    public static void renderBackpackPreview(GuiGraphics context, Minecraft minecraft, AbstractContainerMenu menu, @Nullable Slot hoveredSlot, int leftPos, int topPos, int imageWidth, int imageHeight) {
        boolean requireKey;
        RenderSystem.enableBlend();
        ((BackpackMenu)menu).setPreviewVisible(false);
        switch (Backpack.getConfig().tooltip_modifier.toLowerCase()) {
            case "shift": {
                requireKey = Screen.m_96638_();
                break;
            }
            case "alt": {
                requireKey = Screen.m_96639_();
                break;
            }
            case "ctrl": {
                requireKey = Screen.m_96637_();
                break;
            }
            case "none": {
                requireKey = true;
                break;
            }
            default: {
                if (!Screen.m_96638_()) {
                    return;
                }
                return;
            }
        }
        if (!requireKey) {
            return;
        }
        if (hoveredSlot == null || !menu.m_142621_().m_41619_()) {
            return;
        }
        ItemStack backpackStack = hoveredSlot.m_7993_();
        Item item = backpackStack.m_41720_();
        if (!(item instanceof BackpackItem)) {
            return;
        }
        BackpackItem backpackItem = (BackpackItem)item;
        BackpackRenderer.renderPreviewBackpackBackground(context, backpackStack, leftPos, topPos, imageWidth, imageHeight, (BackpackMenu)menu);
        ((BackpackMenu)menu).setPreviewVisible(true);
        ArrayList<ItemStack> backpackItems = new ArrayList<ItemStack>();
        CompoundTag nbt = backpackStack.m_41783_();
        if (nbt != null && nbt.m_128425_("BackpackItems", 9)) {
            int numSlots = backpackItem.getBackpackType().getSize();
            for (int i = 0; i < numSlots; ++i) {
                backpackItems.add(ItemStack.f_41583_);
            }
            ListTag itemsTag = nbt.m_128437_("BackpackItems", 10);
            for (int i = 0; i < itemsTag.size(); ++i) {
                CompoundTag itemTag = itemsTag.m_128728_(i);
                int slotIndex = itemTag.m_128451_("Slot");
                if (slotIndex < 0 || slotIndex >= numSlots) continue;
                backpackItems.set(slotIndex, ItemStack.m_41712_((CompoundTag)itemTag));
            }
        }
        if (backpackItems.isEmpty()) {
            return;
        }
        int baseHeight = imageHeight;
        int columns = backpackItem.getBackpackType().getColumns();
        int rows = backpackItem.getBackpackType().getRows();
        int startX = -25 - (columns - 1) * 18;
        int startY = (baseHeight - 166) / 2 + 3;
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                int slotIndex = row * columns + column;
                if (slotIndex >= backpackItems.size()) continue;
                int x = leftPos + startX + column * 18;
                int y = topPos + startY + row * 18;
                ItemStack stack = (ItemStack)backpackItems.get(slotIndex);
                context.m_280480_(stack, x, y);
                context.m_280370_(minecraft.f_91062_, stack, x, y);
            }
        }
        RenderSystem.disableBlend();
    }

    public static void renderPreviewBackpackBackground(GuiGraphics context, ItemStack stack, int x, int y, int backgroundWidth, int backgroundHeight, BackpackMenu renderCondition) {
        int width = 256;
        int height = 256;
        ResourceLocation texture = null;
        Item item = stack.m_41720_();
        if (item instanceof BackpackItem) {
            BackpackItem backpackItem = (BackpackItem)item;
            texture = backpackItem.getBackpackType().getGuiTexture();
            width = backpackItem.getBackpackType().guiWidth();
            height = backpackItem.getBackpackType().guiHeight();
        }
        if (texture == null) {
            return;
        }
        int left = x - width - 1 + renderCondition.getBackpackGuiX();
        int top = y + (backgroundHeight - 174) / 2 + renderCondition.getBackpackGuiY();
        context.m_280163_(texture, left, top, 0.0f, 0.0f, width, height, width, height);
    }
}

