/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackPlatform;
import com.yyz.yyzsbackpack.item.BackpackItem;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class SimplifiedBackpackFeatureRenderer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private final ModelPart backpack = this.createBackpackModel();
    private final ModelPart backpack_overlay = this.createBackpackOverlayModel();

    public SimplifiedBackpackFeatureRenderer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> context) {
        super(context);
    }

    private ModelPart createBackpackModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition leather_backpack = partdefinition.m_171599_("leather_backpack", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171488_(-4.0f, -8.0f, -3.0f, 8.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(26, 8).m_171480_().m_171488_(-4.0f, -8.0f, 1.0f, 2.0f, 11.0f, 5.0f, new CubeDeformation(0.1f)).m_171555_(false).m_171514_(26, 8).m_171480_().m_171488_(2.0f, -8.0f, 1.0f, 2.0f, 11.0f, 5.0f, new CubeDeformation(0.1f)).m_171555_(false).m_171514_(4, 0).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)7.75f, (float)4.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition top = leather_backpack.m_171599_("top", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-4.0f, -1.0f, -4.0f, 9.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)-7.5f, (float)0.5f));
        return meshdefinition.m_171576_().m_171583_(64, 64).m_171324_("leather_backpack");
    }

    private ModelPart createBackpackOverlayModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition leather_backpack_overlay = partdefinition.m_171599_("leather_backpack_overlay", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition cube_r2 = leather_backpack_overlay.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(4, 29).m_171488_(-4.5f, -2.0f, 0.0f, 9.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-17.75f, (float)7.25f, (float)0.1309f, (float)3.1416f, (float)0.0f));
        return meshdefinition.m_171576_().m_171583_(64, 64).m_171324_("leather_backpack_overlay");
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, AbstractClientPlayer entity, float f, float g, float h, float j, float k, float l) {
        if (this.shouldRender((Player)entity)) {
            this.renderBackpack(poseStack, multiBufferSource, (Player)entity, i);
        }
    }

    private void renderBackpack(PoseStack matrices, MultiBufferSource vertexConsumers, Player player, int light) {
        Item item = BackpackPlatform.getEquipped(player).m_41720_();
        if (item instanceof BackpackItem) {
            BackpackItem backpackItem = (BackpackItem)item;
            int j = backpackItem.m_41121_(BackpackPlatform.getEquipped(player));
            float red = (float)(j >> 16 & 0xFF) / 255.0f;
            float green = (float)(j >> 8 & 0xFF) / 255.0f;
            float blue = (float)(j & 0xFF) / 255.0f;
            float alpha = (float)(j >> 24 & 0xFF) / 255.0f;
            matrices.m_85836_();
            ((PlayerModel)this.m_117386_()).f_102810_.m_104299_(matrices);
            VertexConsumer vertexConsumer = vertexConsumers.m_6299_(RenderType.m_110452_((ResourceLocation)new ResourceLocation("yyzsbackpack", "textures/backpack/leather_backpack.png")));
            this.backpack.m_104306_(matrices, vertexConsumer, light, OverlayTexture.f_118083_, red, green, blue, 1.0f);
            VertexConsumer overlay_vertexConsumer = vertexConsumers.m_6299_(RenderType.m_110452_((ResourceLocation)new ResourceLocation("yyzsbackpack", "textures/backpack/leather_backpack_overlay.png")));
            this.backpack_overlay.m_104301_(matrices, overlay_vertexConsumer, light, OverlayTexture.f_118083_);
            matrices.m_85849_();
        }
    }

    private boolean shouldRender(Player player) {
        return BackpackPlatform.getEquipped(player).m_41720_() instanceof BackpackItem && Backpack.getConfig().render_backpack_model && Backpack.getConfig().backpack_model_style.equals("simplified");
    }
}

