/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack;

import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackHelper;
import com.yyz.yyzsbackpack.api.BackPackSlot;
import com.yyz.yyzsbackpack.api.BackpackCondition;
import com.yyz.yyzsbackpack.api.EquipPackSlot;
import com.yyz.yyzsbackpack.item.BackpackItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BackpackManager {
    public static final ResourceLocation BACKPACK_TEXTURE = new ResourceLocation("yyzsbackpack", "textures/gui/backpack.png");
    public static final ResourceLocation BACKSLOT_TEXTURE = new ResourceLocation("yyzsbackpack", "item/backslot");
    public static final ResourceLocation SLOT_TEXTURE = new ResourceLocation("yyzsbackpack", "textures/gui//slot.png");

    public static void updateBackpackSlotsPosition(AbstractContainerMenu menu, int backpackSlotStartIndex, int baseHeight, int xOffset, int yOffset) {
        int rows = 9;
        for (int column = 0; column < 6; ++column) {
            for (int row = 0; row < 9; ++row) {
                Slot slot;
                int slotIndex = backpackSlotStartIndex + column * 9 + row;
                if (slotIndex >= menu.f_38839_.size() || !((slot = (Slot)menu.f_38839_.get(slotIndex)) instanceof BackPackSlot)) continue;
                slot.f_40220_ = -25 - column * 18 + xOffset;
                slot.f_40221_ = (baseHeight - 166) / 2 + 3 + row * 18 + yOffset;
            }
        }
    }

    public static void updateEquipmentSlotPosition(AbstractContainerMenu menu, int baseHeight, int xOffset, int yOffset) {
        for (Slot slot : menu.f_38839_) {
            if (!(slot instanceof EquipPackSlot)) continue;
            slot.f_40220_ = 77 + xOffset;
            slot.f_40221_ = (baseHeight - 166) / 2 + 8 + 36 + yOffset;
            break;
        }
    }

    public static void addBackpackSlots(AbstractContainerMenu screenHandler, Container container, Inventory inventory) {
        for (int column = 0; column < 6; ++column) {
            for (int row = 0; row < 9; ++row) {
                int columnIndex = column;
                screenHandler.m_38897_((Slot)new BackPackSlot(screenHandler, container, row + (column + 1) * 9 + 27 + 1, columnIndex, -25 - column * 18, 3 + row * 18));
            }
        }
    }

    public static boolean isTrinketModLoaded() {
        return BackpackHelper.isModLoaded("trinkets") || BackpackHelper.isModLoaded("curios") || BackpackHelper.isModLoaded("accessories");
    }

    public static void renderEquippackSlot(InventoryMenu menu, GuiGraphics guiGraphics, int x, int y) {
        if (BackpackManager.isTrinketModLoaded() && !Backpack.getConfig().force_slot) {
            return;
        }
        guiGraphics.m_280163_(SLOT_TEXTURE, x + ((BackpackCondition)menu).getEquippackXOffset(), y + ((BackpackCondition)menu).getEquippackYOffset(), 0.0f, 0.0f, 18, 18, 18, 18);
    }

    public static void addEquippackSlot(AbstractContainerMenu screenHandler, Inventory inventory) {
        if (BackpackManager.isTrinketModLoaded() && !Backpack.getConfig().force_slot) {
            return;
        }
        screenHandler.m_38897_((Slot)new EquipPackSlot((Container)inventory, 36, 77, 44));
    }

    public static void saveBackpackContents(Container inventory, ItemStack backpackStack) {
        BackpackItem backpackItem = (BackpackItem)backpackStack.m_41720_();
        int columns = backpackItem.getBackpackType().getColumns();
        int numSlots = columns * 9;
        ListTag itemsTag = new ListTag();
        for (int i = 0; i < numSlots; ++i) {
            int slotIndex = 37 + i;
            ItemStack stack = inventory.m_8020_(slotIndex);
            if (stack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            stack.m_41739_(itemTag);
            itemsTag.add((Object)itemTag);
            inventory.m_6836_(slotIndex, ItemStack.f_41583_);
        }
        CompoundTag nbt = backpackStack.m_41784_();
        nbt.m_128365_("BackpackItems", (Tag)itemsTag);
    }

    public static void restoreBackpackContents(Container inventory, ItemStack backpackStack) {
        CompoundTag nbt = backpackStack.m_41783_();
        if (nbt == null || !nbt.m_128425_("BackpackItems", 9)) {
            return;
        }
        BackpackItem backpackItem = (BackpackItem)backpackStack.m_41720_();
        int columns = backpackItem.getBackpackType().getColumns();
        int numSlots = columns * 9;
        ListTag itemsTag = nbt.m_128437_("BackpackItems", 10);
        for (int i = 0; i < itemsTag.size(); ++i) {
            CompoundTag itemTag = itemsTag.m_128728_(i);
            int slotIndex = itemTag.m_128451_("Slot");
            if (slotIndex < 0 || slotIndex >= numSlots) continue;
            ItemStack stack = ItemStack.m_41712_((CompoundTag)itemTag);
            inventory.m_6836_(37 + slotIndex, stack);
        }
        nbt.m_128473_("BackpackItems");
        if (nbt.m_128456_()) {
            backpackStack.m_41751_(null);
        }
    }

    public static void renderBackpackBackground(GuiGraphics context, int x, int y, int backgroundWidth, int backgroundHeight, Inventory inventory, boolean shouldRenderBackpack, BackpackCondition renderCondition) {
        if (!shouldRenderBackpack) {
            return;
        }
        int columns = 0;
        ItemStack stack = BackpackHelper.getEquipped((Player)Minecraft.m_91087_().f_91074_);
        Item item = stack.m_41720_();
        if (item instanceof BackpackItem) {
            BackpackItem backpackItem = (BackpackItem)item;
            columns = backpackItem.getBackpackType().getColumns();
        }
        int width = 14 + columns * 18;
        int left = x - 14 - columns * 18 - 1 + renderCondition.getBackpackXOffset();
        int top = y + (backgroundHeight - 174) / 2 + renderCondition.getBackpackYOffset();
        int u = 14 * (columns - 1) + 18 * (columns - 1) * columns / 2;
        context.m_280163_(BACKPACK_TEXTURE, left, top, (float)u, 0.0f, width, 174, 462, 174);
    }

    public static boolean shouldRenderBackpackExtension(AbstractContainerMenu handler, Inventory inventory) {
        if (inventory != null && ((BackpackCondition)handler).shouldRenderBackpack()) {
            ItemStack backpackStack = BackpackHelper.getEquipped((Player)Minecraft.m_91087_().f_91074_);
            return backpackStack.m_41720_() instanceof BackpackItem;
        }
        return false;
    }

    public static boolean isClickOutsideExtendedBounds(Inventory inventory, boolean outsideOriginalBounds, double mouseX, double mouseY, int left, int top, int backgroundWidth, int backgroundHeight, boolean shouldRenderBackpackExtension, BackpackCondition renderCondition) {
        boolean inBackpackArea = false;
        if (shouldRenderBackpackExtension) {
            int columns = 0;
            ItemStack backpackStack = BackpackHelper.getEquipped((Player)Minecraft.m_91087_().f_91074_);
            Item item = backpackStack.m_41720_();
            if (item instanceof BackpackItem) {
                BackpackItem backpack = (BackpackItem)item;
                columns = backpack.getBackpackType().getColumns();
            }
            int backpackWidth = 14 + columns * 18;
            int backpackX = left - backpackWidth - 1 + renderCondition.getBackpackXOffset();
            int backpackY = top + (backgroundHeight - 174) / 2 + renderCondition.getBackpackYOffset();
            int backpackHeight = 174;
            inBackpackArea = mouseX >= (double)backpackX && mouseX < (double)(backpackX + backpackWidth) && mouseY >= (double)backpackY && mouseY < (double)(backpackY + backpackHeight);
        }
        return outsideOriginalBounds && !inBackpackArea;
    }

    public static class Ref<T> {
        public T value;

        public Ref(T value) {
            this.value = value;
        }
    }
}

