/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.mixin;

import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackHelper;
import com.yyz.yyzsbackpack.BackpackManager;
import com.yyz.yyzsbackpack.api.BackPackSlot;
import com.yyz.yyzsbackpack.api.BackpackCondition;
import com.yyz.yyzsbackpack.item.BackpackItem;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractContainerMenu.class})
public abstract class ScreenHandlerMixin
implements BackpackCondition {
    @Shadow
    @Final
    public NonNullList<Slot> f_38839_;
    @Unique
    private boolean shouldRenderBackpack = false;
    @Unique
    private int backpackXOffset = 0;
    @Unique
    private int backpackYOffset = 0;
    @Unique
    private int equippackXOffset = 0;
    @Unique
    private int equippackYOffset = 0;
    @Unique
    public Inventory inventory;

    @Shadow
    public abstract ItemStack m_142621_();

    @Shadow
    public abstract void m_142503_(ItemStack var1);

    @Shadow
    public abstract Slot m_38853_(int var1);

    @Shadow
    protected abstract boolean m_38903_(ItemStack var1, int var2, int var3, boolean var4);

    @Override
    public boolean shouldRenderBackpack() {
        return this.shouldRenderBackpack;
    }

    @Override
    public void setRenderBackpack(boolean shouldRenderBackpack) {
        this.shouldRenderBackpack = shouldRenderBackpack;
    }

    @Override
    public int getBackpackXOffset() {
        return this.backpackXOffset + Backpack.getConfig().backpack_offsetX;
    }

    @Override
    public int getBackpackYOffset() {
        return this.backpackYOffset + Backpack.getConfig().backpack_offsetY;
    }

    @Override
    public void setBackpackOffset(int x, int y) {
        this.backpackXOffset = x;
        this.backpackYOffset = y;
    }

    @Override
    public int getEquippackXOffset() {
        return this.equippackXOffset + Backpack.getConfig().slot_offsetX;
    }

    @Override
    public int getEquippackYOffset() {
        return this.equippackYOffset + Backpack.getConfig().slot_offsetY;
    }

    @Override
    public void setEquippackOffset(int x, int y) {
        this.equippackXOffset = x;
        this.equippackYOffset = y;
    }

    @Override
    public Inventory getInventory() {
        return this.inventory;
    }

    @Override
    public void setInventory(Inventory inventory) {
        this.inventory = inventory;
    }

    @Inject(method={"clicked"}, at={@At(value="RETURN")})
    private void handleBackpackSwap(int slotIndex, int button, ClickType actionType, Player player, CallbackInfo ci) {
        AbstractContainerMenu menu = (AbstractContainerMenu)this;
        if (slotIndex < 0 || slotIndex >= this.f_38839_.size() || actionType != ClickType.PICKUP || ((Slot)this.f_38839_.get(slotIndex)).m_7993_().m_41720_() instanceof BackpackItem || !Backpack.getConfig().quick_swap) {
            return;
        }
        if (!(this.m_38853_(slotIndex) instanceof BackPackSlot)) {
            return;
        }
        ItemStack back = BackpackHelper.getEquipped(player).m_41777_();
        ItemStack stack = this.m_142621_().m_41777_();
        if (!(back.m_41720_() instanceof BackpackItem) || !(stack.m_41720_() instanceof BackpackItem)) {
            return;
        }
        BackpackManager.saveBackpackContents((Container)player.m_150109_(), back);
        BackpackManager.restoreBackpackContents((Container)player.m_150109_(), stack);
        Container container = BackpackHelper.getContainer(player);
        container.m_6836_(BackpackHelper.getIndex(player), stack);
        this.m_142503_(back);
    }

    @Inject(method={"doClick"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleShiftRightClick(int i, int j, ClickType clickType, Player player, CallbackInfo ci) {
        if (clickType == ClickType.QUICK_MOVE && j == 1) {
            if (i < 0) {
                ci.cancel();
                return;
            }
            Slot slot = (Slot)this.f_38839_.get(i);
            if (!slot.m_8010_(player)) {
                ci.cancel();
                return;
            }
            if (slot instanceof BackPackSlot) {
                ItemStack itemStack = this.quickMoveToHotbar(player, i);
                while (!itemStack.m_41619_() && ItemStack.m_41656_((ItemStack)slot.m_7993_(), (ItemStack)itemStack)) {
                    itemStack = this.quickMoveToHotbar(player, i);
                }
                ci.cancel();
                return;
            }
            if (i >= 9 && i < 45) {
                ItemStack itemStack = this.quickMoveToBackpack(player, i);
                while (!itemStack.m_41619_() && ItemStack.m_41656_((ItemStack)slot.m_7993_(), (ItemStack)itemStack)) {
                    itemStack = this.quickMoveToBackpack(player, i);
                }
                ci.cancel();
            }
        }
    }

    @Unique
    private ItemStack quickMoveToHotbar(Player player, int slotIndex) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemStack = slotStack.m_41777_();
            if (!this.m_38903_(slotStack, 36, 45, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            slot.m_142406_(player, slotStack);
        }
        return itemStack;
    }

    @Unique
    private ItemStack quickMoveToBackpack(Player player, int slotIndex) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemStack = slotStack.m_41777_();
            int backpackStart = -1;
            for (int i = 0; i < this.f_38839_.size(); ++i) {
                if (!(this.f_38839_.get(i) instanceof BackPackSlot)) continue;
                backpackStart = i;
                break;
            }
            if (backpackStart == -1) {
                return ItemStack.f_41583_;
            }
            if (!this.m_38903_(slotStack, backpackStart, backpackStart + 54, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            slot.m_142406_(player, slotStack);
        }
        return itemStack;
    }
}

