/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackPlatform;
import com.yyz.yyzsbackpack.base.BackpackMenu;
import com.yyz.yyzsbackpack.item.BackpackItem;
import com.yyz.yyzsbackpack.util.BackpackHelper;
import java.util.ArrayList;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class BackpackRenderer {
    public static final class_2960 BACKPACK_TEXTURE = new class_2960("yyzsbackpack", "textures/gui/backpack.png");

    public static void renderEquipSlotBackground(class_1723 menu, class_332 guiGraphics, int x, int y) {
        if (BackpackHelper.isTrinketModLoaded() && !Backpack.getConfig().use_dedicated_slot) {
            return;
        }
        guiGraphics.method_25290(new class_2960("yyzsbackpack", "textures/gui//slot.png"), x + ((BackpackMenu)menu).getBackpackEquipSlotX(), y + ((BackpackMenu)menu).getBackpackEquipSlotY(), 0.0f, 0.0f, 18, 18, 18, 18);
    }

    public static void renderEquippedBackpackBackground(class_332 context, int x, int y, int backgroundWidth, int backgroundHeight, class_1661 inventory, boolean shouldRenderBackpack, BackpackMenu renderCondition) {
        RenderSystem.enableBlend();
        if (!shouldRenderBackpack) {
            return;
        }
        int width = 256;
        int height = 256;
        class_2960 texture = null;
        class_1799 stack = BackpackPlatform.getEquipped(inventory.field_7546);
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof BackpackItem) {
            BackpackItem backpackItem = (BackpackItem)class_17922;
            texture = backpackItem.getBackpackType().getGuiTexture();
            width = backpackItem.getBackpackType().guiWidth();
            height = backpackItem.getBackpackType().guiHeight();
        }
        if (texture == null) {
            return;
        }
        int left = x - width - 1 + renderCondition.getBackpackGuiX();
        int top = y + (backgroundHeight - height) / 2 + renderCondition.getBackpackGuiY();
        context.method_25290(texture, left, top, 0.0f, 0.0f, width, height, width, height);
        RenderSystem.disableBlend();
    }

    public static void renderBackpackPreview(class_332 context, class_310 minecraft, class_1703 menu, @Nullable class_1735 hoveredSlot, int leftPos, int topPos, int imageWidth, int imageHeight) {
        boolean requireKey;
        RenderSystem.enableBlend();
        ((BackpackMenu)menu).setPreviewVisible(false);
        switch (Backpack.getConfig().tooltip_modifier.toLowerCase()) {
            case "shift": {
                requireKey = class_437.method_25442();
                break;
            }
            case "alt": {
                requireKey = class_437.method_25443();
                break;
            }
            case "ctrl": {
                requireKey = class_437.method_25441();
                break;
            }
            case "none": {
                requireKey = true;
                break;
            }
            default: {
                if (!class_437.method_25442()) {
                    return;
                }
                return;
            }
        }
        if (!requireKey) {
            return;
        }
        if (hoveredSlot == null || !menu.method_34255().method_7960()) {
            return;
        }
        class_1799 backpackStack = hoveredSlot.method_7677();
        class_1792 class_17922 = backpackStack.method_7909();
        if (!(class_17922 instanceof BackpackItem)) {
            return;
        }
        BackpackItem backpackItem = (BackpackItem)class_17922;
        BackpackRenderer.renderPreviewBackpackBackground(context, backpackStack, leftPos, topPos, imageWidth, imageHeight, (BackpackMenu)menu);
        ((BackpackMenu)menu).setPreviewVisible(true);
        ArrayList<class_1799> backpackItems = new ArrayList<class_1799>();
        class_2487 nbt = backpackStack.method_7969();
        if (nbt != null && nbt.method_10573("BackpackItems", 9)) {
            int numSlots = backpackItem.getBackpackType().getSize();
            for (int i = 0; i < numSlots; ++i) {
                backpackItems.add(class_1799.field_8037);
            }
            class_2499 itemsTag = nbt.method_10554("BackpackItems", 10);
            for (int i = 0; i < itemsTag.size(); ++i) {
                class_2487 itemTag = itemsTag.method_10602(i);
                int slotIndex = itemTag.method_10550("Slot");
                if (slotIndex < 0 || slotIndex >= numSlots) continue;
                backpackItems.set(slotIndex, class_1799.method_7915((class_2487)itemTag));
            }
        }
        if (backpackItems.isEmpty()) {
            return;
        }
        int baseHeight = imageHeight;
        int columns = backpackItem.getBackpackType().getColumns();
        int rows = backpackItem.getBackpackType().getRows();
        int startX = -25 - (columns - 1) * 18;
        int startY = (baseHeight - 166) / 2 + 3;
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                int slotIndex = row * columns + column;
                if (slotIndex >= backpackItems.size()) continue;
                int x = leftPos + startX + column * 18;
                int y = topPos + startY + row * 18;
                class_1799 stack = (class_1799)backpackItems.get(slotIndex);
                context.method_51427(stack, x, y);
                context.method_51431(minecraft.field_1772, stack, x, y);
            }
        }
        RenderSystem.disableBlend();
    }

    public static void renderPreviewBackpackBackground(class_332 context, class_1799 stack, int x, int y, int backgroundWidth, int backgroundHeight, BackpackMenu renderCondition) {
        int width = 256;
        int height = 256;
        class_2960 texture = null;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof BackpackItem) {
            BackpackItem backpackItem = (BackpackItem)class_17922;
            texture = backpackItem.getBackpackType().getGuiTexture();
            width = backpackItem.getBackpackType().guiWidth();
            height = backpackItem.getBackpackType().guiHeight();
        }
        if (texture == null) {
            return;
        }
        int left = x - width - 1 + renderCondition.getBackpackGuiX();
        int top = y + (backgroundHeight - 174) / 2 + renderCondition.getBackpackGuiY();
        context.method_25290(texture, left, top, 0.0f, 0.0f, width, height, width, height);
    }
}

