/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.util;

import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackPlatform;
import com.yyz.yyzsbackpack.base.BackpackStorageSlot;
import com.yyz.yyzsbackpack.item.BackpackItem;
import com.yyz.yyzsbackpack.util.BackpackHelper;
import com.yyz.yyzsbackpack.util.BackpackStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class BackpackSorter {
    public static void sortInventorySlots(class_1657 player, class_2371<class_1735> slots) {
        ArrayList<class_1735> inventorySlots = new ArrayList<class_1735>();
        for (class_1735 slot : slots) {
            int index;
            if (!(slot.field_7871 instanceof class_1661) || (index = slot.method_34266()) < 9 || index >= 36) continue;
            inventorySlots.add(slot);
        }
        BackpackSorter.sortSlots(inventorySlots);
    }

    public static void sortBackpackSlots(class_1657 player, class_2371<class_1735> slots) {
        ArrayList<class_1735> backpackSlots = new ArrayList<class_1735>();
        for (class_1735 slot : slots) {
            if (!(slot instanceof BackpackStorageSlot)) continue;
            backpackSlots.add(slot);
        }
        BackpackSorter.sortSlots(backpackSlots);
    }

    public static void sortContainerSlots(class_1657 player, class_1263 container, class_2371<class_1735> slots) {
        ArrayList<class_1735> containerSlots = new ArrayList<class_1735>();
        for (class_1735 slot : slots) {
            if (slot.field_7871 != container || slot.field_7871 instanceof class_1661) continue;
            containerSlots.add(slot);
        }
        BackpackSorter.sortSlots(containerSlots);
    }

    private static void sortSlots(List<class_1735> slotsToSort) {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        for (class_1735 class_17352 : slotsToSort) {
            if (class_17352.method_7677().method_7960()) continue;
            items.add(class_17352.method_7677().method_7972());
            class_17352.method_7673(class_1799.field_8037);
        }
        HashMap<class_2960, List> groupedItems = new HashMap<class_2960, List>();
        for (class_1799 stack : items) {
            class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
            groupedItems.computeIfAbsent(id, k -> new ArrayList()).add(stack);
        }
        ArrayList arrayList = new ArrayList(groupedItems.keySet());
        Collections.sort(arrayList);
        int slotIndex = 0;
        block2: for (class_2960 id : arrayList) {
            List stacks = (List)groupedItems.get(id);
            List<class_1799> merged = BackpackSorter.mergeStacks(stacks);
            for (class_1799 stack : merged) {
                if (slotIndex >= slotsToSort.size()) continue block2;
                slotsToSort.get(slotIndex++).method_7673(stack);
            }
        }
    }

    private static List<class_1799> mergeStacks(List<class_1799> stacks) {
        ArrayList<class_1799> merged = new ArrayList<class_1799>();
        if (stacks.isEmpty()) {
            return merged;
        }
        class_1799 current = stacks.get(0).method_7972();
        for (int i = 1; i < stacks.size(); ++i) {
            class_1799 next = stacks.get(i);
            if (class_1799.method_31577((class_1799)current, (class_1799)next)) {
                int space = current.method_7914() - current.method_7947();
                if (space > 0) {
                    int transfer = Math.min(space, next.method_7947());
                    current.method_7933(transfer);
                    next.method_7934(transfer);
                }
                if (next.method_7947() <= 0) continue;
            }
            merged.add(current);
            current = next.method_7972();
        }
        merged.add(current);
        return merged;
    }

    public static void handleBackpackSwap(class_1703 menu, class_2371<class_1735> slots, class_1799 carried, int slotIndex, int button, class_1713 actionType, class_1657 player) {
        if (slotIndex < 0 || slotIndex >= slots.size() || actionType != class_1713.field_7790 || ((class_1735)slots.get(slotIndex)).method_7677().method_7909() instanceof BackpackItem || !Backpack.getConfig().quick_swap_backpack) {
            return;
        }
        if (!(menu.method_7611(slotIndex) instanceof BackpackStorageSlot)) {
            return;
        }
        class_1799 back = BackpackPlatform.getEquipped(player).method_7972();
        class_1799 stack = carried.method_7972();
        if (!(back.method_7909() instanceof BackpackItem) || !(stack.method_7909() instanceof BackpackItem)) {
            return;
        }
        BackpackStorage.saveBackpackContents((class_1263)player.method_31548(), back, true);
        BackpackStorage.restoreBackpackContents((class_1263)player.method_31548(), stack);
        class_1263 container = BackpackPlatform.getContainer(player);
        container.method_5447(BackpackPlatform.getIndex(player), stack);
        menu.method_34254(back);
    }

    public static class_1799 quickMoveToHotbar(class_1703 menu, class_1657 player, int slotIndex, class_2371<class_1735> slots) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)slots.get(slotIndex);
        int hotbarStart = -1;
        int hotbarEnd = -1;
        for (int idx = 0; idx < slots.size(); ++idx) {
            class_1735 s = (class_1735)slots.get(idx);
            if (!(s.field_7871 instanceof class_1661) || s.method_34266() < 0 || s.method_34266() >= 9) continue;
            if (hotbarStart == -1) {
                hotbarStart = idx;
            }
            hotbarEnd = idx + 1;
        }
        if (slot != null && slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            itemStack = slotStack.method_7972();
            if (!menu.method_7616(slotStack, hotbarStart, hotbarEnd, false)) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            slot.method_7667(player, slotStack);
        }
        return itemStack;
    }

    public static class_1799 quickMoveToBackpack(class_1703 menu, class_1657 player, int slotIndex, class_2371<class_1735> slots) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)slots.get(slotIndex);
        if (slot != null && slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            itemStack = slotStack.method_7972();
            int backpackStart = -1;
            for (int i = 0; i < slots.size(); ++i) {
                if (!(slots.get(i) instanceof BackpackStorageSlot)) continue;
                backpackStart = i;
                break;
            }
            if (backpackStart == -1) {
                return class_1799.field_8037;
            }
            if (!menu.method_7616(slotStack, backpackStart, backpackStart + BackpackHelper.getMaxBackpackSize(), false)) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            slot.method_7667(player, slotStack);
        }
        return itemStack;
    }

    public static void quickMoveTo(class_1703 menu, class_2371<class_1735> slots, int i, int j, class_1713 clickType, class_1657 player, CallbackInfo ci) {
        if (clickType == class_1713.field_7794 && j == 1) {
            if (i < 0) {
                ci.cancel();
                return;
            }
            class_1735 slot = (class_1735)slots.get(i);
            if (!slot.method_7674(player)) {
                ci.cancel();
                return;
            }
            if (slot instanceof BackpackStorageSlot) {
                class_1799 itemStack = BackpackSorter.quickMoveToHotbar(menu, player, i, slots);
                while (!itemStack.method_7960() && class_1799.method_7984((class_1799)slot.method_7677(), (class_1799)itemStack)) {
                    itemStack = BackpackSorter.quickMoveToHotbar(menu, player, i, slots);
                }
                ci.cancel();
            } else {
                class_1799 itemStack = BackpackSorter.quickMoveToBackpack(menu, player, i, slots);
                while (!itemStack.method_7960() && class_1799.method_7984((class_1799)slot.method_7677(), (class_1799)itemStack)) {
                    itemStack = BackpackSorter.quickMoveToBackpack(menu, player, i, slots);
                }
                ci.cancel();
            }
        } else if (clickType == class_1713.field_7794 && j == 2) {
            boolean isContainerSlot;
            int slotIndexInPlayerInv;
            class_1735 hoveredSlot = (class_1735)slots.get(i);
            boolean isInventorySlot = false;
            if (hoveredSlot.field_7871 instanceof class_1661 && (slotIndexInPlayerInv = hoveredSlot.method_34266()) >= 9 && slotIndexInPlayerInv < 36) {
                isInventorySlot = true;
            }
            boolean isBackpackSlot = hoveredSlot instanceof BackpackStorageSlot;
            boolean bl = isContainerSlot = !isInventorySlot && !isBackpackSlot && hoveredSlot.field_7871 != player.method_31548();
            if (!(isInventorySlot || isBackpackSlot || isContainerSlot)) {
                return;
            }
            if (isInventorySlot) {
                BackpackSorter.sortInventorySlots(player, slots);
            } else if (isBackpackSlot) {
                BackpackSorter.sortBackpackSlots(player, slots);
            } else {
                BackpackSorter.sortContainerSlots(player, hoveredSlot.field_7871, slots);
            }
        }
    }
}

