/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.mixin;

import com.yyz.yyzsbackpack.BackpackHelper;
import com.yyz.yyzsbackpack.BackpackManager;
import com.yyz.yyzsbackpack.api.BackPackSlot;
import com.yyz.yyzsbackpack.api.BackpackExclusionZoneProvider;
import com.yyz.yyzsbackpack.api.BackpackRenderCondition;
import com.yyz.yyzsbackpack.item.BackpackItem;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractContainerScreen.class})
public abstract class HandledScreenMixin<T extends AbstractContainerMenu>
extends Screen
implements BackpackExclusionZoneProvider {
    @Shadow
    protected int imageWidth;
    @Shadow
    protected int imageHeight;
    @Shadow
    protected int leftPos;
    @Shadow
    protected int topPos;
    @Shadow
    @Final
    protected T menu;
    @Unique
    private Inventory playerInventory;
    @Unique
    private boolean shouldRenderBackpackExtension = false;
    @Unique
    private boolean previousBackpackState = false;

    @Shadow
    protected abstract boolean hasClickedOutside(double var1, double var3, int var5, int var6, int var7);

    protected HandledScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"renderBackground(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="RETURN")})
    private void onRenderBackground(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        BackpackManager.renderBackpackBackground(context, this.leftPos, this.topPos, this.imageWidth, this.imageHeight, this.playerInventory, this.shouldRenderBackpackExtension, (BackpackRenderCondition)this.menu);
    }

    @ModifyConstant(method={"checkHotbarMouseClicked(I)V"}, constant={@Constant(intValue=40)})
    private int adjustOffhandSlotPosition(int original) {
        return 95;
    }

    @ModifyConstant(method={"checkHotbarKeyPressed(II)Z"}, constant={@Constant(intValue=40)})
    private int adjustOffhandSlotPositionHotbar(int original) {
        return 95;
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="HEAD")})
    private void checkBackpackStateChange(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        boolean currentState = BackpackManager.shouldRenderBackpackExtension(this.menu, this.playerInventory);
        if (currentState != this.previousBackpackState) {
            this.shouldRenderBackpackExtension = currentState;
            this.previousBackpackState = currentState;
            this.rebuildWidgets();
        }
    }

    @Redirect(method={"mouseClicked(DDI)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;hasClickedOutside(DDIII)Z"))
    private boolean handleMouseClicked(AbstractContainerScreen<?> instance, double mouseX, double mouseY, int left, int top, int button) {
        return this.menu instanceof BackpackRenderCondition ? BackpackManager.isClickOutsideExtendedBounds(this.playerInventory, this.hasClickedOutside(mouseX, mouseY, this.leftPos, this.topPos, button), mouseX, mouseY, this.leftPos, this.topPos, this.imageWidth, this.imageHeight, this.shouldRenderBackpackExtension, (BackpackRenderCondition)this.menu) : this.hasClickedOutside(mouseX, mouseY, this.leftPos, this.topPos, button);
    }

    @Redirect(method={"mouseReleased(DDI)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;hasClickedOutside(DDIII)Z"))
    private boolean handleMouseReleased(AbstractContainerScreen<?> instance, double mouseX, double mouseY, int left, int top, int button) {
        return this.menu instanceof BackpackRenderCondition ? BackpackManager.isClickOutsideExtendedBounds(this.playerInventory, this.hasClickedOutside(mouseX, mouseY, this.leftPos, this.topPos, button), mouseX, mouseY, this.leftPos, this.topPos, this.imageWidth, this.imageHeight, this.shouldRenderBackpackExtension, (BackpackRenderCondition)this.menu) : this.hasClickedOutside(mouseX, mouseY, this.leftPos, this.topPos, button);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/inventory/AbstractContainerMenu;Lnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/network/chat/Component;)V"}, at={@At(value="TAIL")})
    private void initializeFields(AbstractContainerMenu abstractContainerMenu, Inventory inventory, Component component, CallbackInfo ci) {
        this.playerInventory = inventory;
        this.previousBackpackState = this.shouldRenderBackpackExtension = BackpackManager.shouldRenderBackpackExtension(this.menu, this.playerInventory);
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="HEAD")})
    private void updateBackpackSlotsPositionBeforeRender(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        Screen screen = this;
        if (screen instanceof CreativeModeInventoryScreen) {
            return;
        }
        if (this.menu instanceof BackpackRenderCondition) {
            int baseHeight = this.imageHeight;
            int backpackSlotStartIndex = -1;
            for (int i = 0; i < ((AbstractContainerMenu)this.menu).slots.size(); ++i) {
                if (!(((AbstractContainerMenu)this.menu).slots.get(i) instanceof BackPackSlot)) continue;
                backpackSlotStartIndex = i;
                break;
            }
            if (backpackSlotStartIndex == -1) {
                return;
            }
            int xOffset = ((BackpackRenderCondition)this.menu).getBackpackXOffset();
            int yOffset = ((BackpackRenderCondition)this.menu).getBackpackYOffset();
            int xOffset1 = ((BackpackRenderCondition)this.menu).getEquippackXOffset();
            int yOffset1 = ((BackpackRenderCondition)this.menu).getEquippackYOffset();
            BackpackManager.updateBackpackSlotsPosition(this.menu, backpackSlotStartIndex, baseHeight, xOffset, yOffset);
            BackpackManager.updateEquipmentSlotPosition(this.menu, baseHeight, xOffset1, yOffset1);
        }
    }

    @Override
    public List<Rect2i> getBackpackExclusionZones() {
        int xOffset = ((BackpackRenderCondition)this.menu).getBackpackXOffset();
        int yOffset = ((BackpackRenderCondition)this.menu).getBackpackYOffset();
        if (!this.shouldRenderBackpackExtension) {
            return Collections.emptyList();
        }
        int columns = 0;
        ItemStack backpackStack = BackpackHelper.getEquipped((Player)Minecraft.getInstance().player);
        Item item = backpackStack.getItem();
        if (item instanceof BackpackItem) {
            BackpackItem backpack = (BackpackItem)item;
            columns = backpack.getBackpackType().getColumns();
        }
        int baseWidth = 14 + columns * 18;
        int height = 174;
        int x = this.leftPos - baseWidth - 1 + xOffset;
        int y = this.topPos + (this.imageHeight - height) / 2 + yOffset;
        int actualWidth = baseWidth;
        if (xOffset != 0) {
            actualWidth = xOffset > 0 ? (actualWidth += xOffset) : (actualWidth -= xOffset);
            actualWidth = Math.max(actualWidth, baseWidth);
        }
        return Collections.singletonList(new Rect2i(x, y, actualWidth, height));
    }
}

