/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.neoforge.mixin.compat.accessories;

import com.yyz.yyzsbackpack.BackpackManager;
import com.yyz.yyzsbackpack.item.BackpackItem;
import io.wispforest.accessories.api.menu.AccessoriesBasedSlot;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={AccessoriesBasedSlot.class})
public abstract class AccessoriesBasedSlotMixin
extends Slot {
    @Shadow(remap=false)
    @Final
    public LivingEntity entity;

    public AccessoriesBasedSlotMixin(Container container, int i, int j, int k) {
        super(container, i, j, k);
    }

    public void onTake(@NotNull Player player, ItemStack backpackStack) {
        if (backpackStack.getItem() instanceof BackpackItem && this.entity instanceof Player) {
            BackpackManager.saveBackpackContents((Container)player.getInventory(), backpackStack);
        }
        super.onTake(player, backpackStack);
    }

    public void setByPlayer(@NotNull ItemStack newBackpackStack) {
        LivingEntity livingEntity = this.entity;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack oldBackpackStack = this.getItem();
            if (!oldBackpackStack.isEmpty() && oldBackpackStack.getItem() instanceof BackpackItem) {
                BackpackManager.saveBackpackContents((Container)player.getInventory(), oldBackpackStack);
            }
            super.setByPlayer(newBackpackStack);
            if (!newBackpackStack.isEmpty() && newBackpackStack.getItem() instanceof BackpackItem) {
                BackpackManager.restoreBackpackContents((Container)player.getInventory(), newBackpackStack);
            }
        }
    }
}

