/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackPlatform;
import com.yyz.yyzsbackpack.config.BackpackConfig;
import java.io.File;
import java.util.Set;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public class BackpackCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"yyzsbackpack").requires(source -> source.method_9259(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"set").then(class_2170.method_9247((String)"quick_swap_backpack").then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> BackpackCommand.setBoolean((CommandContext<class_2168>)ctx, "quick_swap_backpack"))))).then(class_2170.method_9247((String)"use_dedicated_slot").then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> BackpackCommand.setBoolean((CommandContext<class_2168>)ctx, "use_dedicated_slot"))))).then(class_2170.method_9247((String)"render_backpack_model").then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> BackpackCommand.setBoolean((CommandContext<class_2168>)ctx, "render_backpack_model"))))).then(class_2170.method_9247((String)"restrict_container_items").then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> BackpackCommand.setBoolean((CommandContext<class_2168>)ctx, "restrict_container_items"))))).then(class_2170.method_9247((String)"slot_position_x").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> BackpackCommand.setInt((CommandContext<class_2168>)ctx, "slot_position_x"))))).then(class_2170.method_9247((String)"slot_position_y").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> BackpackCommand.setInt((CommandContext<class_2168>)ctx, "slot_position_y"))))).then(class_2170.method_9247((String)"backpack_gui_x").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> BackpackCommand.setInt((CommandContext<class_2168>)ctx, "backpack_gui_x"))))).then(class_2170.method_9247((String)"backpack_gui_y").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> BackpackCommand.setInt((CommandContext<class_2168>)ctx, "backpack_gui_y"))))).then(class_2170.method_9247((String)"tooltip_modifier").then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.string()).executes(BackpackCommand::setTipKey)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"restricted_items").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"item", (ArgumentType)StringArgumentType.string()).executes(BackpackCommand::addItem)))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"item", (ArgumentType)StringArgumentType.string()).executes(BackpackCommand::removeItem)))).then(class_2170.method_9247((String)"clear").executes(BackpackCommand::clearItems)))).then(class_2170.method_9247((String)"reload").executes(BackpackCommand::reloadConfig))));
    }

    private static int setBoolean(CommandContext<class_2168> ctx, String property) {
        boolean value = BoolArgumentType.getBool(ctx, (String)"value");
        BackpackCommand.setProperty(property, value);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Set " + property + " to " + value)), true);
        return 1;
    }

    private static int setInt(CommandContext<class_2168> ctx, String property) {
        int value = IntegerArgumentType.getInteger(ctx, (String)"value");
        BackpackCommand.setProperty(property, value);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Set " + property + " to " + value)), true);
        return 1;
    }

    private static int setTipKey(CommandContext<class_2168> ctx) {
        String value = StringArgumentType.getString(ctx, (String)"value");
        if (!Set.of("shift", "alt", "ctrl", "none").contains(value)) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid value! Must be: shift, alt, ctrl, none"));
            return 0;
        }
        BackpackCommand.setProperty("tooltip_modifier", value);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Set tooltip_modifier to " + value)), true);
        return 1;
    }

    private static void setProperty(String name, Object value) {
        BackpackConfig config = Backpack.getConfig();
        try {
            config.getClass().getField(name).set(config, value);
            config.saveConfig(new File(String.valueOf(BackpackPlatform.getConfigDirectory().resolve("yyzsbackpack")) + "/yyzsbackpack.json"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static int addItem(CommandContext<class_2168> ctx) {
        String item = StringArgumentType.getString(ctx, (String)"item");
        BackpackConfig config = Backpack.getConfig();
        if (config.restricted_items.add(item)) {
            config.saveConfig(new File(String.valueOf(BackpackPlatform.getConfigDirectory().resolve("yyzsbackpack")) + "/yyzsbackpack.json"));
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Added item: " + item)), true);
            return 1;
        }
        ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Item already exists!"));
        return 0;
    }

    private static int removeItem(CommandContext<class_2168> ctx) {
        String item = StringArgumentType.getString(ctx, (String)"item");
        BackpackConfig config = Backpack.getConfig();
        if (config.restricted_items.remove(item)) {
            config.saveConfig(new File(String.valueOf(BackpackPlatform.getConfigDirectory().resolve("yyzsbackpack")) + "/yyzsbackpack.json"));
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Removed item: " + item)), true);
            return 1;
        }
        ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Item not found!"));
        return 0;
    }

    private static int clearItems(CommandContext<class_2168> ctx) {
        BackpackConfig config = Backpack.getConfig();
        config.restricted_items.clear();
        config.saveConfig(new File(String.valueOf(BackpackPlatform.getConfigDirectory().resolve("yyzsbackpack")) + "/yyzsbackpack.json"));
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Cleared all container items"), true);
        return 1;
    }

    private static int reloadConfig(CommandContext<class_2168> ctx) {
        Backpack.init();
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Reloaded backpack config"), true);
        return 1;
    }
}

