/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackPlatform;
import com.yyz.yyzsbackpack.base.BackpackRenderState;
import com.yyz.yyzsbackpack.item.BackpackItem;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;

public class DetailedBackpackFeatureRenderer
extends RenderLayer<PlayerRenderState, PlayerModel> {
    private final ModelPart backpack = this.createBackpackModel();
    private final ModelPart backpack_overlay = this.createBackpackOverlayModel();

    public DetailedBackpackFeatureRenderer(RenderLayerParent<PlayerRenderState, PlayerModel> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, PlayerRenderState entityRenderState, float f, float g) {
        AbstractClientPlayer player = ((BackpackRenderState)entityRenderState).getAbstractClientPlayer();
        if (this.shouldRender((Player)player)) {
            this.renderBackpack(poseStack, multiBufferSource, (Player)player, i);
        }
    }

    private ModelPart createBackpackModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition backpack = partdefinition.addOrReplaceChild("backpack", CubeListBuilder.create().texOffs(38, 27).addBox(-5.0f, -14.5f, -4.0f, 10.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-6.0f, -14.0f, -5.0f, 12.0f, 14.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 19).addBox(-5.0f, -5.0f, 0.0f, 10.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(12, 31).addBox(-4.0f, -12.0f, 0.0f, 8.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(22, 19).addBox(-6.9f, -7.0f, -5.0f, 1.0f, 7.0f, 5.0f, new CubeDeformation(-0.1f)).texOffs(34, 0).addBox(-7.5f, -6.0f, -4.0f, 1.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(34, 0).addBox(-6.7f, -13.0f, -4.0f, 1.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(34, 8).addBox(5.7f, -13.0f, -4.0f, 1.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 25).addBox(5.9f, -7.0f, -5.0f, 1.0f, 7.0f, 5.0f, new CubeDeformation(-0.1f)).texOffs(34, 8).addBox(6.5f, -6.0f, -4.0f, 1.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(38, 23).addBox(-5.0f, -0.5f, -4.0f, 10.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)14.0f, (float)8.0f));
        return meshdefinition.getRoot().bake(64, 64).getChild("backpack");
    }

    private ModelPart createBackpackOverlayModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition backpack_overlay = partdefinition.addOrReplaceChild("backpack_overlay", CubeListBuilder.create().texOffs(30, 31).addBox(-2.0f, -18.0f, 7.0f, 4.0f, 3.0f, 2.0f, new CubeDeformation(-0.3f)).texOffs(42, 32).addBox(0.0f, -13.5f, 8.25f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return meshdefinition.getRoot().bake(64, 64).getChild("backpack_overlay");
    }

    private boolean shouldRender(Player player) {
        return BackpackPlatform.getEquipped(player).getItem() instanceof BackpackItem && Backpack.getConfig().render_backpack_model && Backpack.getConfig().backpack_model_style.equals("detailed");
    }

    private ResourceLocation getTexture(Player player) {
        return ResourceLocation.fromNamespaceAndPath((String)"yyzsbackpack", (String)"textures/backpack/backpack.png");
    }

    private ResourceLocation getOverlayTexture(Player player) {
        Item item = BackpackPlatform.getEquipped(player).getItem();
        if (item instanceof BackpackItem) {
            BackpackItem backpackItem = (BackpackItem)item;
            return backpackItem.getBackpackType().getModelTexture();
        }
        return ResourceLocation.fromNamespaceAndPath((String)"yyzsbackpack", (String)"textures/backpack/gold_backpack.png");
    }

    private void renderBackpack(PoseStack matrices, MultiBufferSource vertexConsumers, Player player, int light) {
        if (BackpackPlatform.getEquipped(player).getItem() instanceof BackpackItem) {
            int j = DyedItemColor.getOrDefault((ItemStack)BackpackPlatform.getEquipped(player), (int)-6265536);
            matrices.pushPose();
            ((PlayerModel)this.getParentModel()).body.translateAndRotate(matrices);
            matrices.scale(0.8f, 0.8f, 0.8f);
            VertexConsumer vertexConsumer = vertexConsumers.getBuffer(RenderType.entitySolid((ResourceLocation)this.getTexture(player)));
            this.backpack.render(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY, j);
            VertexConsumer overlay_vertexConsumer = vertexConsumers.getBuffer(RenderType.entitySolid((ResourceLocation)this.getOverlayTexture(player)));
            this.backpack_overlay.render(matrices, overlay_vertexConsumer, light, OverlayTexture.NO_OVERLAY);
            matrices.popPose();
        }
    }
}

