/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.mixin;

import net.minecraft.core.NonNullList;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Inventory.class})
public abstract class Inventory2Mixin {
    private NonNullList<ItemStack> backpackitems;

    @Shadow
    public abstract void setItem(int var1, ItemStack var2);

    @Inject(method={"<init>(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/EntityEquipment;)V"}, at={@At(value="RETURN")})
    private void addSlot(Player player, EntityEquipment entityEquipment, CallbackInfo ci) {
        this.backpackitems = NonNullList.withSize((int)54, (Object)ItemStack.EMPTY);
    }

    @Inject(method={"save(Lnet/minecraft/world/level/storage/ValueOutput$TypedOutputList;)V"}, at={@At(value="RETURN")})
    private void addSlot(ValueOutput.TypedOutputList<ItemStackWithSlot> typedOutputList, CallbackInfo ci) {
        for (int i = 0; i < this.backpackitems.size(); ++i) {
            ItemStack itemStack = (ItemStack)this.backpackitems.get(i);
            if (itemStack.isEmpty()) continue;
            typedOutputList.add((Object)new ItemStackWithSlot(i, itemStack));
        }
    }

    @Inject(method={"load(Lnet/minecraft/world/level/storage/ValueInput$TypedInputList;)V"}, at={@At(value="RETURN")})
    private void addSlot(ValueInput.TypedInputList<ItemStackWithSlot> typedInputList, CallbackInfo ci) {
        this.backpackitems.clear();
        for (ItemStackWithSlot itemStackWithSlot : typedInputList) {
            if (!itemStackWithSlot.isValidInContainer(this.backpackitems.size())) continue;
            this.setItem(itemStackWithSlot.slot(), itemStackWithSlot.stack());
        }
    }

    @Inject(method={"getContainerSize()I"}, at={@At(value="RETURN")}, cancellable=true)
    private void addSlot(CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((Object)((Integer)cir.getReturnValue() + 54));
    }
}

