/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.util;

import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackPlatform;
import com.yyz.yyzsbackpack.base.BackpackEffect;
import com.yyz.yyzsbackpack.item.BackpackItem;
import com.yyz.yyzsbackpack.util.BackpackHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class BackpackStorage {
    public static void saveBackpackContents(Container inventory, ItemStack backpackStack, boolean b) {
        BackpackItem backpackItem = (BackpackItem)backpackStack.getItem();
        int numSlots = backpackItem.getBackpackType().getSize();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(numSlots);
        for (int i = 0; i < numSlots; ++i) {
            int slotIndex = 36 + i;
            ItemStack stack = inventory.getItem(slotIndex);
            items.add(stack.copy());
            if (!b) continue;
            inventory.setItem(slotIndex, ItemStack.EMPTY);
        }
        backpackStack.set(BackpackPlatform.getBackpackItemsComponent(), items);
    }

    public static void restoreBackpackContents(Container inventory, ItemStack backpackStack) {
        List items = (List)backpackStack.get(BackpackPlatform.getBackpackItemsComponent());
        if (items == null) {
            return;
        }
        BackpackItem backpackItem = (BackpackItem)backpackStack.getItem();
        int numSlots = backpackItem.getBackpackType().getSize();
        for (int i = 0; i < Math.min(items.size(), numSlots); ++i) {
            ItemStack stack = (ItemStack)items.get(i);
            if (stack.isEmpty()) continue;
            inventory.setItem(36 + i, stack.copy());
        }
        backpackStack.remove(BackpackPlatform.getBackpackItemsComponent());
    }

    public static int countNonEmptyBackpacks(Container playerInventory) {
        int nonEmptyBackpackCount = 0;
        block0: for (int slot = 0; slot < playerInventory.getContainerSize(); ++slot) {
            List backpackItems;
            ItemStack stack = playerInventory.getItem(slot);
            if (!(stack.getItem() instanceof BackpackItem) || (backpackItems = (List)stack.get(BackpackPlatform.getBackpackItemsComponent())) == null) continue;
            for (ItemStack content : backpackItems) {
                if (content.isEmpty()) continue;
                ++nonEmptyBackpackCount;
                continue block0;
            }
        }
        return nonEmptyBackpackCount;
    }

    public static void updateEffectsByBackpackCount(Player player, List<Holder<MobEffect>> lastAppliedEffects) {
        int backpackCount = BackpackStorage.countNonEmptyBackpacks((Container)player.getInventory());
        for (Holder<MobEffect> effect : new ArrayList<Holder<MobEffect>>(lastAppliedEffects)) {
            player.removeEffect(effect);
            lastAppliedEffects.remove(effect);
        }
        List<BackpackEffect> effects = Backpack.getConfig().backpack_multi_effects;
        if (backpackCount > 0 && !effects.isEmpty()) {
            int effectIndex = Math.min(backpackCount, effects.size()) - 1;
            BackpackEffect effect = effects.get(effectIndex);
            Holder<MobEffect> effectType = BackpackHelper.getEffectHolder(effect.effectType);
            if (effectType == null) {
                return;
            }
            player.addEffect(new MobEffectInstance(effectType, -1, effect.amplifier), (Entity)player);
            if (!lastAppliedEffects.contains(effectType)) {
                lastAppliedEffects.add(effectType);
            }
        }
    }

    public static void returnBackpackFromAccessorySlot(Player player) {
        int ACCESSORY_SLOT;
        if (player.level().isClientSide) {
            return;
        }
        Inventory inventory = player.getInventory();
        ItemStack accessoryItem = inventory.getItem(ACCESSORY_SLOT = 36 + BackpackHelper.getMaxBackpackSize());
        if (accessoryItem.getItem() instanceof BackpackItem && BackpackHelper.isTrinketModLoaded() && !Backpack.getConfig().use_dedicated_slot) {
            BackpackStorage.saveBackpackContents((Container)inventory, accessoryItem, true);
            inventory.setItem(ACCESSORY_SLOT, ItemStack.EMPTY);
            if (!inventory.add(accessoryItem)) {
                player.drop(accessoryItem, false);
            }
        }
    }

    public static void saveEquippedBackpackOnDeath(ServerPlayer player) {
        ItemStack equippedBackpack = BackpackPlatform.getEquipped((Player)player);
        if (equippedBackpack.getItem() instanceof BackpackItem) {
            BackpackStorage.saveBackpackContents((Container)player.getInventory(), equippedBackpack, BackpackPlatform.getEmptyRule((Player)player));
        }
    }

    public static void restoreNonEmptyBackpack(Player player) {
        ItemStack equippedBackpack = BackpackPlatform.getEquipped(player);
        if (equippedBackpack.has(BackpackPlatform.getBackpackItemsComponent())) {
            BackpackStorage.restoreBackpackContents((Container)player.getInventory(), equippedBackpack);
        }
    }
}

