/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackPlatform;
import com.yyz.yyzsbackpack.base.BackpackEffect;
import com.yyz.yyzsbackpack.config.BackpackConfig;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class BackpackCommand {
    private static final String[] MODIFIER_SUGGESTIONS = new String[]{"shift", "alt", "ctrl", "none"};

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"yyzsbackpack").requires(source -> source.method_9259(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"config").then(class_2170.method_9247((String)"quick_swap_backpack").then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> BackpackCommand.setBoolean((CommandContext<class_2168>)ctx, "quick_swap_backpack"))))).then(class_2170.method_9247((String)"use_dedicated_slot").then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> BackpackCommand.setBoolean((CommandContext<class_2168>)ctx, "use_dedicated_slot"))))).then(class_2170.method_9247((String)"render_backpack_model").then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> BackpackCommand.setBoolean((CommandContext<class_2168>)ctx, "render_backpack_model"))))).then(class_2170.method_9247((String)"restrict_container_items").then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> BackpackCommand.setBoolean((CommandContext<class_2168>)ctx, "restrict_container_items"))))).then(class_2170.method_9247((String)"slot_position_x").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> BackpackCommand.setInt((CommandContext<class_2168>)ctx, "slot_position_x"))))).then(class_2170.method_9247((String)"slot_position_y").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> BackpackCommand.setInt((CommandContext<class_2168>)ctx, "slot_position_y"))))).then(class_2170.method_9247((String)"backpack_gui_x").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> BackpackCommand.setInt((CommandContext<class_2168>)ctx, "backpack_gui_x"))))).then(class_2170.method_9247((String)"backpack_gui_y").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> BackpackCommand.setInt((CommandContext<class_2168>)ctx, "backpack_gui_y"))))).then(class_2170.method_9247((String)"tooltip_modifier").then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9253((String[])MODIFIER_SUGGESTIONS, (SuggestionsBuilder)builder)).executes(BackpackCommand::setTipKey)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"restricted_items").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"item", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> BackpackCommand.suggestAllItems((class_2168)context.getSource(), builder)).executes(BackpackCommand::addItem)))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"item", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> BackpackCommand.suggestConfiguredItems((class_2168)context.getSource(), builder)).executes(BackpackCommand::removeItem)))).then(class_2170.method_9247((String)"clear").executes(BackpackCommand::clearItems)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"backpack_multi_effects").then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"tier", (ArgumentType)IntegerArgumentType.integer((int)0)).then(class_2170.method_9244((String)"effect", (ArgumentType)StringArgumentType.string()).suggests(BackpackCommand::suggestEffectTypes).then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(BackpackCommand::setEffect)))))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"effect", (ArgumentType)StringArgumentType.string()).suggests(BackpackCommand::suggestEffectTypes).then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(BackpackCommand::addEffect))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"tier", (ArgumentType)IntegerArgumentType.integer((int)0)).suggests(BackpackCommand::suggestEffectTiers).executes(BackpackCommand::removeEffect)))).then(class_2170.method_9247((String)"clear").executes(BackpackCommand::clearEffects)))).then(class_2170.method_9247((String)"reload").executes(BackpackCommand::reloadConfig))));
    }

    private static int setBoolean(CommandContext<class_2168> ctx, String property) {
        boolean value = BoolArgumentType.getBool(ctx, (String)"value");
        BackpackCommand.setProperty(property, value);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.yyzsbackpack.set.boolean", (Object[])new Object[]{property, String.valueOf(value)}), true);
        return 1;
    }

    private static int setInt(CommandContext<class_2168> ctx, String property) {
        int value = IntegerArgumentType.getInteger(ctx, (String)"value");
        BackpackCommand.setProperty(property, value);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.yyzsbackpack.set.integer", (Object[])new Object[]{property, value}), true);
        return 1;
    }

    private static int setTipKey(CommandContext<class_2168> ctx) {
        String value = StringArgumentType.getString(ctx, (String)"value");
        if (!Set.of("shift", "alt", "ctrl", "none").contains(value)) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43471((String)"command.yyzsbackpack.set.tooltip_modifier.invalid"));
            return 0;
        }
        BackpackCommand.setProperty("tooltip_modifier", value);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.yyzsbackpack.set.tooltip_modifier", (Object[])new Object[]{value}), true);
        return 1;
    }

    private static void setProperty(String name, Object value) {
        BackpackConfig config = Backpack.getConfig();
        try {
            config.getClass().getField(name).set(config, value);
            config.saveConfig(new File(String.valueOf(BackpackPlatform.getConfigDirectory().resolve("yyzsbackpack")) + "/yyzsbackpack.json"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static int addItem(CommandContext<class_2168> ctx) {
        String item = StringArgumentType.getString(ctx, (String)"item");
        BackpackConfig config = Backpack.getConfig();
        if (config.restricted_items.add(item)) {
            config.saveConfig(new File(String.valueOf(BackpackPlatform.getConfigDirectory().resolve("yyzsbackpack")) + "/yyzsbackpack.json"));
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.yyzsbackpack.restricted_items.add", (Object[])new Object[]{item}), true);
            return 1;
        }
        ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43471((String)"command.yyzsbackpack.restricted_items.exists"));
        return 0;
    }

    private static int removeItem(CommandContext<class_2168> ctx) {
        String item = StringArgumentType.getString(ctx, (String)"item");
        BackpackConfig config = Backpack.getConfig();
        if (config.restricted_items.remove(item)) {
            config.saveConfig(new File(String.valueOf(BackpackPlatform.getConfigDirectory().resolve("yyzsbackpack")) + "/yyzsbackpack.json"));
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.yyzsbackpack.restricted_items.remove", (Object[])new Object[]{item}), true);
            return 1;
        }
        ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43471((String)"command.yyzsbackpack.restricted_items.not_found"));
        return 0;
    }

    private static int clearItems(CommandContext<class_2168> ctx) {
        BackpackConfig config = Backpack.getConfig();
        config.restricted_items.clear();
        config.saveConfig(new File(String.valueOf(BackpackPlatform.getConfigDirectory().resolve("yyzsbackpack")) + "/yyzsbackpack.json"));
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43471((String)"command.yyzsbackpack.restricted_items.clear"), true);
        return 1;
    }

    private static int reloadConfig(CommandContext<class_2168> ctx) {
        Backpack.init();
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43471((String)"command.yyzsbackpack.reload"), true);
        return 1;
    }

    private static CompletableFuture<Suggestions> suggestAllItems(class_2168 source, SuggestionsBuilder builder) {
        Set itemIds = class_7923.field_41178.method_10235();
        ArrayList<CallSite> quotedSuggestions = new ArrayList<CallSite>();
        for (class_2960 id : itemIds) {
            quotedSuggestions.add((CallSite)((Object)("\"" + id.toString() + "\"")));
        }
        return class_2172.method_9265(quotedSuggestions, (SuggestionsBuilder)builder.createOffset(builder.getStart()));
    }

    private static CompletableFuture<Suggestions> suggestConfiguredItems(class_2168 source, SuggestionsBuilder builder) {
        Set<String> configuredItems = Backpack.getConfig().restricted_items;
        ArrayList<CallSite> quotedSuggestions = new ArrayList<CallSite>();
        for (String item : configuredItems) {
            quotedSuggestions.add((CallSite)((Object)("\"" + item + "\"")));
        }
        return class_2172.method_9265(quotedSuggestions, (SuggestionsBuilder)builder.createOffset(builder.getStart()));
    }

    private static int setEffect(CommandContext<class_2168> ctx) {
        int tier = IntegerArgumentType.getInteger(ctx, (String)"tier");
        String effect = StringArgumentType.getString(ctx, (String)"effect");
        int level = IntegerArgumentType.getInteger(ctx, (String)"level");
        BackpackConfig config = Backpack.getConfig();
        List<BackpackEffect> effects = config.backpack_multi_effects;
        while (effects.size() <= tier) {
            effects.add(new BackpackEffect("none", 0));
        }
        BackpackEffect be = effects.get(tier);
        be.effectType = effect;
        be.amplifier = level;
        config.saveConfig(new File(String.valueOf(BackpackPlatform.getConfigDirectory().resolve("yyzsbackpack")) + "/yyzsbackpack.json"));
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.yyzsbackpack.effect.set", (Object[])new Object[]{tier, effect, level}), true);
        return 1;
    }

    private static int addEffect(CommandContext<class_2168> ctx) {
        String effect = StringArgumentType.getString(ctx, (String)"effect");
        int level = IntegerArgumentType.getInteger(ctx, (String)"level");
        BackpackConfig config = Backpack.getConfig();
        config.backpack_multi_effects.add(new BackpackEffect(effect, level));
        config.saveConfig(new File(String.valueOf(BackpackPlatform.getConfigDirectory().resolve("yyzsbackpack")) + "/yyzsbackpack.json"));
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.yyzsbackpack.effect.add", (Object[])new Object[]{effect, level}), true);
        return 1;
    }

    private static int removeEffect(CommandContext<class_2168> ctx) {
        int tier = IntegerArgumentType.getInteger(ctx, (String)"tier");
        BackpackConfig config = Backpack.getConfig();
        List<BackpackEffect> effects = config.backpack_multi_effects;
        if (tier >= effects.size()) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43469((String)"command.yyzsbackpack.effect.invalid_tier", (Object[])new Object[]{effects.size() - 1}));
            return 0;
        }
        effects.remove(tier);
        config.saveConfig(new File(String.valueOf(BackpackPlatform.getConfigDirectory().resolve("yyzsbackpack")) + "/yyzsbackpack.json"));
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"command.yyzsbackpack.effect.remove", (Object[])new Object[]{tier}), true);
        return 1;
    }

    private static int clearEffects(CommandContext<class_2168> ctx) {
        BackpackConfig config = Backpack.getConfig();
        config.backpack_multi_effects.clear();
        config.saveConfig(new File(String.valueOf(BackpackPlatform.getConfigDirectory().resolve("yyzsbackpack")) + "/yyzsbackpack.json"));
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43471((String)"command.yyzsbackpack.effect.clear"), true);
        return 1;
    }

    private static CompletableFuture<Suggestions> suggestEffectTypes(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        ArrayList<String> suggestions = new ArrayList<String>();
        suggestions.add("\"none\"");
        class_7923.field_41174.method_10235().forEach(id -> suggestions.add("\"" + id.toString() + "\""));
        return class_2172.method_9265(suggestions, (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> suggestEffectTiers(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        BackpackConfig config = Backpack.getConfig();
        ArrayList<String> tiers = new ArrayList<String>();
        for (int i = 0; i < config.backpack_multi_effects.size(); ++i) {
            tiers.add(String.valueOf(i));
        }
        return class_2172.method_9265(tiers, (SuggestionsBuilder)builder);
    }
}

