/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.yyz.yyzsbackpack.base.BackpackEffect;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BackpackConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<String, List<String>> FIELD_COMMENTS = new HashMap<String, List<String>>();
    public boolean quick_swap_backpack = true;
    public boolean use_dedicated_slot = false;
    public boolean render_backpack_model = true;
    public boolean restrict_container_items = false;
    public int slot_position_x = 0;
    public int slot_position_y = 0;
    public int backpack_gui_x = 0;
    public int backpack_gui_y = 0;
    public String tooltip_modifier = "shift";
    public String backpack_model_style = "detailed";
    public Set<String> restricted_items = new HashSet<String>();
    public List<BackpackEffect> backpack_multi_effects = new ArrayList<BackpackEffect>(){
        {
            this.add(new BackpackEffect("none", 0));
            this.add(new BackpackEffect("none", 0));
            this.add(new BackpackEffect("minecraft:slowness", 1));
        }
    };

    private static void addComment(String field, String ... lines) {
        FIELD_COMMENTS.put(field, List.of(lines));
    }

    public static BackpackConfig loadConfig(File file) {
        BackpackConfig config;
        block19: {
            if (file.exists() && file.isFile()) {
                try (FileInputStream fileInputStream = new FileInputStream(file);
                     InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
                     BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                    String line;
                    StringBuilder configBuilder = new StringBuilder();
                    while ((line = bufferedReader.readLine()) != null) {
                        if (line.trim().startsWith("//") || line.trim().isEmpty()) continue;
                        configBuilder.append(line).append("\n");
                    }
                    config = (BackpackConfig)GSON.fromJson(configBuilder.toString(), BackpackConfig.class);
                    break block19;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load config", e);
                }
            }
            config = new BackpackConfig();
        }
        config.saveConfig(file);
        return config;
    }

    public void saveConfig(File configFile) {
        try {
            String json = GSON.toJson((Object)this);
            StringBuilder output = new StringBuilder();
            String[] lines = json.split("\n");
            Pattern fieldPattern = Pattern.compile("^\\s*\"([^\"]+)\"\\s*:");
            for (String line : lines) {
                String fieldName;
                Matcher matcher = fieldPattern.matcher(line);
                if (matcher.find() && FIELD_COMMENTS.containsKey(fieldName = matcher.group(1))) {
                    String indent = line.substring(0, line.indexOf(34));
                    for (String commentLine : FIELD_COMMENTS.get(fieldName)) {
                        output.append(indent).append("// ").append(commentLine).append("\n");
                    }
                }
                output.append(line).append("\n");
            }
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), StandardCharsets.UTF_8);){
                writer.write(output.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save config", e);
        }
    }

    static {
        BackpackConfig.addComment("quick_swap_backpack", "Enable quick backpack swapping");
        BackpackConfig.addComment("use_dedicated_slot", "Force use of dedicated backpack slot instead of accessory slot");
        BackpackConfig.addComment("render_backpack_model", "Render backpack model");
        BackpackConfig.addComment("restrict_container_items", "Prevent container items (like Shulker Boxes) from being placed in backpack");
        BackpackConfig.addComment("slot_position_x", "X position of backpack slot");
        BackpackConfig.addComment("slot_position_y", "Y position of backpack slot");
        BackpackConfig.addComment("backpack_gui_x", "X position of backpack GUI");
        BackpackConfig.addComment("backpack_gui_y", "Y position of backpack GUI");
        BackpackConfig.addComment("tooltip_modifier", "Backpack preview modifier key (alt, ctrl, none)");
        BackpackConfig.addComment("backpack_model_style", "detailed/simplified");
        BackpackConfig.addComment("restricted_items", "Additional container items", "Format: \"namespace:item_id\"", "Example: \"minecraft:shulker_box\",", "         \"minecraft:shulker_box\",", "         \"minecraft:shulker_box\",");
        BackpackConfig.addComment("backpack_multi_effects", "Multi-tier backpack effects configuration", "Each element in the list corresponds to an additional backpack tier:", "  - Index 0: Effect for carrying 1 extra backpack", "  - Index 1: Effect for carrying 2 extra backpacks", "  - Index 2: Effect for carrying 3 extra backpacks", "  - And so on...", "", "Each effect must contain the following fields:", "  - \"effectType\": Effect ID (e.g. \"minecraft:speed\")", "  - \"amplifier\": Effect level (0-based)", "", "Example configuration:", "[", "  { // Effect for carrying 1 extra backpack", "    \"effectType\": \"none\", // No effect", "    \"amplifier\": 0", "  },", "  { // Effect for carrying 2 extra backpacks", "    \"effectType\": \"minecraft:slowness\",", "    \"amplifier\": 1", "  },", "  { // Effect for carrying 3 extra backpacks", "    \"effectType\": \"minecraft:slowness\",", "    \"amplifier\": 3", "  }", "]");
    }
}

