/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackPlatform;
import com.yyz.yyzsbackpack.config.BackpackConfig;
import java.io.File;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class BackpackCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"yyzsbackpack").requires(source -> source.m_6761_(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(Commands.m_82127_((String)"quick_swap_backpack").then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> BackpackCommand.setBoolean((CommandContext<CommandSourceStack>)ctx, "quick_swap_backpack"))))).then(Commands.m_82127_((String)"use_dedicated_slot").then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> BackpackCommand.setBoolean((CommandContext<CommandSourceStack>)ctx, "use_dedicated_slot"))))).then(Commands.m_82127_((String)"render_backpack_model").then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> BackpackCommand.setBoolean((CommandContext<CommandSourceStack>)ctx, "render_backpack_model"))))).then(Commands.m_82127_((String)"restrict_container_items").then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> BackpackCommand.setBoolean((CommandContext<CommandSourceStack>)ctx, "restrict_container_items"))))).then(Commands.m_82127_((String)"slot_position_x").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> BackpackCommand.setInt((CommandContext<CommandSourceStack>)ctx, "slot_position_x"))))).then(Commands.m_82127_((String)"slot_position_y").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> BackpackCommand.setInt((CommandContext<CommandSourceStack>)ctx, "slot_position_y"))))).then(Commands.m_82127_((String)"backpack_gui_x").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> BackpackCommand.setInt((CommandContext<CommandSourceStack>)ctx, "backpack_gui_x"))))).then(Commands.m_82127_((String)"backpack_gui_y").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> BackpackCommand.setInt((CommandContext<CommandSourceStack>)ctx, "backpack_gui_y"))))).then(Commands.m_82127_((String)"tooltip_modifier").then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.string()).executes(BackpackCommand::setTipKey)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"restricted_items").then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"item", (ArgumentType)StringArgumentType.string()).executes(BackpackCommand::addItem)))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"item", (ArgumentType)StringArgumentType.string()).executes(BackpackCommand::removeItem)))).then(Commands.m_82127_((String)"clear").executes(BackpackCommand::clearItems)))).then(Commands.m_82127_((String)"reload").executes(BackpackCommand::reloadConfig))));
    }

    private static int setBoolean(CommandContext<CommandSourceStack> ctx, String property) {
        boolean value = BoolArgumentType.getBool(ctx, (String)"value");
        BackpackCommand.setProperty(property, value);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Set " + property + " to " + value)), true);
        return 1;
    }

    private static int setInt(CommandContext<CommandSourceStack> ctx, String property) {
        int value = IntegerArgumentType.getInteger(ctx, (String)"value");
        BackpackCommand.setProperty(property, value);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Set " + property + " to " + value)), true);
        return 1;
    }

    private static int setTipKey(CommandContext<CommandSourceStack> ctx) {
        String value = StringArgumentType.getString(ctx, (String)"value");
        if (!Set.of("shift", "alt", "ctrl", "none").contains(value)) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Invalid value! Must be: shift, alt, ctrl, none"));
            return 0;
        }
        BackpackCommand.setProperty("tooltip_modifier", value);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Set tooltip_modifier to " + value)), true);
        return 1;
    }

    private static void setProperty(String name, Object value) {
        BackpackConfig config = Backpack.getConfig();
        try {
            config.getClass().getField(name).set(config, value);
            config.saveConfig(new File(String.valueOf(BackpackPlatform.getConfigDirectory().resolve("yyzsbackpack")) + "/yyzsbackpack.json"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static int addItem(CommandContext<CommandSourceStack> ctx) {
        String item = StringArgumentType.getString(ctx, (String)"item");
        BackpackConfig config = Backpack.getConfig();
        if (config.restricted_items.add(item)) {
            config.saveConfig(new File(String.valueOf(BackpackPlatform.getConfigDirectory().resolve("yyzsbackpack")) + "/yyzsbackpack.json"));
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Added item: " + item)), true);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Item already exists!"));
        return 0;
    }

    private static int removeItem(CommandContext<CommandSourceStack> ctx) {
        String item = StringArgumentType.getString(ctx, (String)"item");
        BackpackConfig config = Backpack.getConfig();
        if (config.restricted_items.remove(item)) {
            config.saveConfig(new File(String.valueOf(BackpackPlatform.getConfigDirectory().resolve("yyzsbackpack")) + "/yyzsbackpack.json"));
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Removed item: " + item)), true);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Item not found!"));
        return 0;
    }

    private static int clearItems(CommandContext<CommandSourceStack> ctx) {
        BackpackConfig config = Backpack.getConfig();
        config.restricted_items.clear();
        config.saveConfig(new File(String.valueOf(BackpackPlatform.getConfigDirectory().resolve("yyzsbackpack")) + "/yyzsbackpack.json"));
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Cleared all container items"), true);
        return 1;
    }

    private static int reloadConfig(CommandContext<CommandSourceStack> ctx) {
        Backpack.init();
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Reloaded backpack config"), true);
        return 1;
    }
}

