/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackPlatform;
import com.yyz.yyzsbackpack.item.BackpackItem;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class DetailedBackpackFeatureRenderer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private final ModelPart backpack = this.createBackpackModel();
    private final ModelPart backpack_overlay = this.createBackpackOverlayModel();

    public DetailedBackpackFeatureRenderer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> context) {
        super(context);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, AbstractClientPlayer entity, float f, float g, float h, float j, float k, float l) {
        if (this.shouldRender((Player)entity)) {
            this.renderBackpack(poseStack, multiBufferSource, (Player)entity, i, h);
        }
    }

    private ModelPart createBackpackModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition backpack = partdefinition.m_171599_("backpack", CubeListBuilder.m_171558_().m_171514_(38, 27).m_171488_(-5.0f, -14.5f, -4.0f, 10.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-6.0f, -14.0f, -5.0f, 12.0f, 14.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 19).m_171488_(-5.0f, -5.0f, 0.0f, 10.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(12, 31).m_171488_(-4.0f, -12.0f, 0.0f, 8.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(22, 19).m_171488_(-6.9f, -7.0f, -5.0f, 1.0f, 7.0f, 5.0f, new CubeDeformation(-0.1f)).m_171514_(34, 0).m_171488_(-7.5f, -6.0f, -4.0f, 1.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(34, 0).m_171488_(-6.7f, -13.0f, -4.0f, 1.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(34, 8).m_171488_(5.7f, -13.0f, -4.0f, 1.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 25).m_171488_(5.9f, -7.0f, -5.0f, 1.0f, 7.0f, 5.0f, new CubeDeformation(-0.1f)).m_171514_(34, 8).m_171488_(6.5f, -6.0f, -4.0f, 1.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(38, 23).m_171488_(-5.0f, -0.5f, -4.0f, 10.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)8.0f));
        return meshdefinition.m_171576_().m_171583_(64, 64).m_171324_("backpack");
    }

    private ModelPart createBackpackOverlayModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition backpack_overlay = partdefinition.m_171599_("backpack_overlay", CubeListBuilder.m_171558_().m_171514_(30, 31).m_171488_(-2.0f, -18.0f, 7.0f, 4.0f, 3.0f, 2.0f, new CubeDeformation(-0.3f)).m_171514_(42, 32).m_171488_(0.0f, -13.5f, 8.25f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        return meshdefinition.m_171576_().m_171583_(64, 64).m_171324_("backpack_overlay");
    }

    private boolean shouldRender(Player player) {
        return BackpackPlatform.getEquipped(player).m_41720_() instanceof BackpackItem && Backpack.getConfig().render_backpack_model && Backpack.getConfig().backpack_model_style.equals("detailed");
    }

    private ResourceLocation getTexture(Player player) {
        return new ResourceLocation("yyzsbackpack", "textures/backpack/backpack.png");
    }

    private ResourceLocation getOverlayTexture(Player player) {
        Item item = BackpackPlatform.getEquipped(player).m_41720_();
        if (item instanceof BackpackItem) {
            BackpackItem backpackItem = (BackpackItem)item;
            return backpackItem.getBackpackType().getModelTexture();
        }
        return new ResourceLocation("yyzsbackpack", "textures/backpack/gold_backpack.png");
    }

    private void renderBackpack(PoseStack matrices, MultiBufferSource vertexConsumers, Player player, int light, float tickDelta) {
        Item item = BackpackPlatform.getEquipped(player).m_41720_();
        if (item instanceof BackpackItem) {
            BackpackItem backpackItem = (BackpackItem)item;
            int j = backpackItem.getColor(BackpackPlatform.getEquipped(player));
            float red = (float)(j >> 16 & 0xFF) / 255.0f;
            float green = (float)(j >> 8 & 0xFF) / 255.0f;
            float blue = (float)(j & 0xFF) / 255.0f;
            float alpha = (float)(j >> 24 & 0xFF) / 255.0f;
            matrices.m_85836_();
            ((PlayerModel)this.m_117386_()).f_102810_.m_104299_(matrices);
            matrices.m_85841_(0.8f, 0.8f, 0.8f);
            VertexConsumer vertexConsumer = vertexConsumers.m_6299_(RenderType.m_110446_((ResourceLocation)this.getTexture(player)));
            this.backpack.m_104306_(matrices, vertexConsumer, light, OverlayTexture.f_118083_, red, green, blue, alpha);
            VertexConsumer overlay_vertexConsumer = vertexConsumers.m_6299_(RenderType.m_110446_((ResourceLocation)this.getOverlayTexture(player)));
            this.backpack_overlay.m_104301_(matrices, overlay_vertexConsumer, light, OverlayTexture.f_118083_);
            matrices.m_85849_();
        }
    }
}

