/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.forge;

import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackPlatform;
import com.yyz.yyzsbackpack.compat.AccessoriesContainerAdapter;
import com.yyz.yyzsbackpack.forge.compat.curios.CuriosContainerAdapter;
import com.yyz.yyzsbackpack.item.BackpackItem;
import com.yyz.yyzsbackpack.util.BackpackHelper;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.common.CuriosConfig;

@Mod(value="yyzsbackpack")
public final class BackpackForge {
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"yyzsbackpack");
    public static final RegistryObject<CreativeModeTab> BACKPACK_TAB = TABS.register("backpack_tab", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)GOLD_BACKPACK.get())).m_257941_((Component)Component.m_237115_((String)"itemGroup.yyzsbackpack.title")).m_257501_((context, entries) -> {
        entries.m_246326_((ItemLike)IRON_BACKPACK.get());
        entries.m_246326_((ItemLike)GOLD_BACKPACK.get());
        entries.m_246326_((ItemLike)DIAMOND_BACKPACK.get());
        entries.m_246326_((ItemLike)NETHERITE_BACKPACK.get());
    }).m_257652_());
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"yyzsbackpack");
    public static final RegistryObject<Item> NETHERITE_BACKPACK = ITEMS.register("netherite_backpack", () -> new BackpackItem("netherite", new Item.Properties().m_41487_(1).m_41486_()));
    public static final RegistryObject<Item> DIAMOND_BACKPACK = ITEMS.register("diamond_backpack", () -> new BackpackItem("diamond", new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> GOLD_BACKPACK = ITEMS.register("gold_backpack", () -> new BackpackItem("gold", new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> IRON_BACKPACK = ITEMS.register("iron_backpack", () -> new BackpackItem("iron", new Item.Properties().m_41487_(1)));

    public static ItemStack getEquipped(Player player) {
        if (!Backpack.getConfig().use_dedicated_slot) {
            AccessoriesCapability capability;
            if (BackpackPlatform.isModLoaded("curios")) {
                Optional backpackSlot;
                Optional curiosHandler = CuriosApi.getCuriosInventory((LivingEntity)player).resolve();
                if (curiosHandler.isPresent() && (backpackSlot = ((ICuriosItemHandler)curiosHandler.get()).findFirstCurio(stack -> stack.m_41720_() instanceof BackpackItem)).isPresent()) {
                    return ((SlotResult)backpackSlot.get()).stack();
                }
            } else if (BackpackPlatform.isModLoaded("accessories") && !BackpackPlatform.isModLoaded("curios") && (capability = AccessoriesCapability.get((LivingEntity)player)) != null) {
                Map containers = capability.getContainers();
                for (AccessoriesContainer container : containers.values()) {
                    ExpandedSimpleContainer accessoriesContainer = container.getAccessories();
                    for (int i = 0; i < accessoriesContainer.m_6643_(); ++i) {
                        ItemStack stack2 = accessoriesContainer.m_8020_(i);
                        if (!(stack2.m_41720_() instanceof BackpackItem)) continue;
                        return stack2;
                    }
                }
            }
        }
        return player.m_150109_().m_8020_(36 + BackpackHelper.getMaxBackpackSize());
    }

    public static Container getContainer(Player player) {
        if (!Backpack.getConfig().use_dedicated_slot) {
            AccessoriesCapability capability;
            if (BackpackPlatform.isModLoaded("curios")) {
                Optional backpackSlot;
                Optional curiosHandler = CuriosApi.getCuriosInventory((LivingEntity)player).resolve();
                if (curiosHandler.isPresent() && (backpackSlot = ((ICuriosItemHandler)curiosHandler.get()).findFirstCurio(stack -> stack.m_41720_() instanceof BackpackItem)).isPresent()) {
                    String slotId = ((SlotResult)backpackSlot.get()).slotContext().identifier();
                    int slotIndex = ((SlotResult)backpackSlot.get()).slotContext().index();
                    Optional stacksHandler = ((ICuriosItemHandler)curiosHandler.get()).getStacksHandler(slotId);
                    if (stacksHandler.isPresent()) {
                        return new CuriosContainerAdapter(((ICurioStacksHandler)stacksHandler.get()).getStacks(), slotIndex);
                    }
                }
            } else if (BackpackPlatform.isModLoaded("accessories") && !BackpackPlatform.isModLoaded("curios") && (capability = AccessoriesCapability.get((LivingEntity)player)) != null) {
                Map containers = capability.getContainers();
                for (AccessoriesContainer container : containers.values()) {
                    ExpandedSimpleContainer accessoriesContainer = container.getAccessories();
                    for (int i = 0; i < accessoriesContainer.m_6643_(); ++i) {
                        ItemStack stack2 = accessoriesContainer.m_8020_(i);
                        if (!(stack2.m_41720_() instanceof BackpackItem)) continue;
                        return new AccessoriesContainerAdapter((Container)accessoriesContainer, i);
                    }
                }
            }
        }
        return player.m_150109_();
    }

    public static int getIndex(Player player) {
        if (!Backpack.getConfig().use_dedicated_slot) {
            Container container;
            if (BackpackPlatform.isModLoaded("curios")) {
                CuriosContainerAdapter container2;
                Optional backpackSlot;
                Optional curiosHandler = CuriosApi.getCuriosInventory((LivingEntity)player).resolve();
                if (curiosHandler.isPresent() && (backpackSlot = ((ICuriosItemHandler)curiosHandler.get()).findFirstCurio(stack -> stack.m_41720_() instanceof BackpackItem)).isPresent() && (container2 = (CuriosContainerAdapter)BackpackForge.getContainer(player)) != null) {
                    return container2.getBackpackSlotIndex();
                }
            } else if (BackpackPlatform.isModLoaded("accessories") && !BackpackPlatform.isModLoaded("curios") && (container = BackpackForge.getContainer(player)) instanceof AccessoriesContainerAdapter) {
                return ((AccessoriesContainerAdapter)container).getBackpackSlotIndex();
            }
        }
        return 36 + BackpackHelper.getMaxBackpackSize();
    }

    public BackpackForge() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        TABS.register(modEventBus);
        ITEMS.register(modEventBus);
        Backpack.init();
    }

    public static boolean getEmptyRule(Player player) {
        return !BackpackPlatform.isModLoaded("curios") || player.m_9236_().m_46469_().m_46207_(GameRules.f_46133_) || CuriosConfig.SERVER.keepCurios.get() != CuriosConfig.KeepCurios.ON;
    }
}

