/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.mixin;

import com.yyz.yyzsbackpack.util.BackpackStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin {
    @Unique
    ServerPlayer yyzsbackpack$player = (ServerPlayer)this;
    @Unique
    List<MobEffect> yyzsbackpack$lastAppliedEffects = new ArrayList<MobEffect>();

    @Inject(method={"die"}, at={@At(value="HEAD")})
    private void onPlayerDeath(DamageSource damageSource, CallbackInfo ci) {
        BackpackStorage.saveEquippedBackpackOnDeath(this.yyzsbackpack$player);
    }

    @Inject(method={"initMenu"}, at={@At(value="HEAD")})
    private void onOpenMenu(CallbackInfo ci) {
        BackpackStorage.returnBackpackFromAccessorySlot((Player)this.yyzsbackpack$player);
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void onTick(CallbackInfo ci) {
        BackpackStorage.restoreNonEmptyBackpack((Player)this.yyzsbackpack$player);
        BackpackStorage.updateEffectsByBackpackCount((Player)this.yyzsbackpack$player, this.yyzsbackpack$lastAppliedEffects);
    }
}

