/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.util;

import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackPlatform;
import com.yyz.yyzsbackpack.base.BackpackEffect;
import com.yyz.yyzsbackpack.item.BackpackItem;
import com.yyz.yyzsbackpack.util.BackpackHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class BackpackStorage {
    public static void saveBackpackContents(Container inventory, ItemStack backpackStack, boolean b) {
        BackpackItem backpackItem = (BackpackItem)backpackStack.m_41720_();
        int numSlots = backpackItem.getBackpackType().getSize();
        ListTag itemsTag = new ListTag();
        for (int i = 0; i < numSlots; ++i) {
            int slotIndex = 36 + i;
            ItemStack stack = inventory.m_8020_(slotIndex);
            if (stack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            stack.m_41739_(itemTag);
            itemsTag.add((Object)itemTag);
            if (!b) continue;
            inventory.m_6836_(slotIndex, ItemStack.f_41583_);
        }
        CompoundTag nbt = backpackStack.m_41784_();
        nbt.m_128365_("BackpackItems", (Tag)itemsTag);
    }

    public static void restoreBackpackContents(Container inventory, ItemStack backpackStack) {
        CompoundTag nbt = backpackStack.m_41783_();
        if (nbt == null || !nbt.m_128425_("BackpackItems", 9)) {
            return;
        }
        BackpackItem backpackItem = (BackpackItem)backpackStack.m_41720_();
        int numSlots = backpackItem.getBackpackType().getSize();
        ListTag itemsTag = nbt.m_128437_("BackpackItems", 10);
        for (int i = 0; i < itemsTag.size(); ++i) {
            CompoundTag itemTag = itemsTag.m_128728_(i);
            int slotIndex = itemTag.m_128451_("Slot");
            if (slotIndex < 0 || slotIndex >= numSlots) continue;
            ItemStack stack = ItemStack.m_41712_((CompoundTag)itemTag);
            inventory.m_6836_(36 + slotIndex, stack);
        }
        nbt.m_128473_("BackpackItems");
        if (nbt.m_128456_()) {
            backpackStack.m_41751_(null);
        }
    }

    public static int countNonEmptyBackpacks(Container playerInventory) {
        int nonEmptyBackpackCount = 0;
        block0: for (int slot = 0; slot < playerInventory.m_6643_(); ++slot) {
            CompoundTag nbt;
            ItemStack stack = playerInventory.m_8020_(slot);
            if (!(stack.m_41720_() instanceof BackpackItem) || (nbt = stack.m_41783_()) == null || !nbt.m_128425_("BackpackItems", 9)) continue;
            ListTag backpackItems = nbt.m_128437_("BackpackItems", 10);
            for (int i = 0; i < backpackItems.size(); ++i) {
                CompoundTag itemTag = backpackItems.m_128728_(i);
                ItemStack content = ItemStack.m_41712_((CompoundTag)itemTag);
                if (content.m_41619_()) continue;
                ++nonEmptyBackpackCount;
                continue block0;
            }
        }
        return nonEmptyBackpackCount;
    }

    public static void updateEffectsByBackpackCount(Player player, List<MobEffect> lastAppliedEffects) {
        int backpackCount = BackpackStorage.countNonEmptyBackpacks((Container)player.m_150109_());
        for (MobEffect effect : new ArrayList<MobEffect>(lastAppliedEffects)) {
            player.m_21195_(effect);
            lastAppliedEffects.remove(effect);
        }
        List<BackpackEffect> effects = Backpack.getConfig().backpack_multi_effects;
        if (backpackCount > 0 && !effects.isEmpty()) {
            int effectIndex = Math.min(backpackCount, effects.size()) - 1;
            BackpackEffect effect = effects.get(effectIndex);
            MobEffect effectType = BackpackHelper.getEffectHolder(effect.effectType);
            if (effectType == null) {
                return;
            }
            player.m_147207_(new MobEffectInstance(effectType, -1, effect.amplifier), (Entity)player);
            if (!lastAppliedEffects.contains(effectType)) {
                lastAppliedEffects.add(effectType);
            }
        }
    }

    public static void returnBackpackFromAccessorySlot(Player player) {
        int ACCESSORY_SLOT;
        if (player.m_9236_().f_46443_) {
            return;
        }
        Inventory inventory = player.m_150109_();
        ItemStack accessoryItem = inventory.m_8020_(ACCESSORY_SLOT = 36 + BackpackHelper.getMaxBackpackSize());
        if (accessoryItem.m_41720_() instanceof BackpackItem && BackpackHelper.isTrinketModLoaded() && !Backpack.getConfig().use_dedicated_slot) {
            BackpackStorage.saveBackpackContents((Container)inventory, accessoryItem, true);
            inventory.m_6836_(ACCESSORY_SLOT, ItemStack.f_41583_);
            if (!inventory.m_36054_(accessoryItem)) {
                player.m_36176_(accessoryItem, false);
            }
        }
    }

    public static void saveEquippedBackpackOnDeath(ServerPlayer player) {
        ItemStack equippedBackpack = BackpackPlatform.getEquipped((Player)player);
        if (equippedBackpack.m_41720_() instanceof BackpackItem) {
            BackpackStorage.saveBackpackContents((Container)player.m_150109_(), equippedBackpack, BackpackPlatform.getEmptyRule((Player)player));
        }
    }

    public static void restoreNonEmptyBackpack(Player player) {
        ItemStack equippedBackpack = BackpackPlatform.getEquipped(player);
        CompoundTag nbt = equippedBackpack.m_41783_();
        if (nbt != null && nbt.m_128425_("BackpackItems", 9)) {
            BackpackStorage.restoreBackpackContents((Container)player.m_150109_(), equippedBackpack);
        }
    }
}

