/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack;

import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackHelper;
import com.yyz.yyzsbackpack.api.BackPackSlot;
import com.yyz.yyzsbackpack.api.BackpackCondition;
import com.yyz.yyzsbackpack.api.EquipPackSlot;
import com.yyz.yyzsbackpack.item.BackpackItem;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class BackpackManager {
    public static final class_2960 BACKPACK_TEXTURE = new class_2960("yyzsbackpack", "textures/gui/backpack.png");
    public static final class_2960 BACKSLOT_TEXTURE = new class_2960("yyzsbackpack", "item/backslot");
    public static final class_2960 SLOT_TEXTURE = new class_2960("yyzsbackpack", "textures/gui//slot.png");

    public static void updateBackpackSlotsPosition(class_1703 menu, int backpackSlotStartIndex, int baseHeight, int xOffset, int yOffset) {
        int rows = 9;
        for (int column = 0; column < 6; ++column) {
            for (int row = 0; row < 9; ++row) {
                class_1735 slot;
                int slotIndex = backpackSlotStartIndex + column * 9 + row;
                if (slotIndex >= menu.field_7761.size() || !((slot = (class_1735)menu.field_7761.get(slotIndex)) instanceof BackPackSlot)) continue;
                slot.field_7873 = -25 - column * 18 + xOffset;
                slot.field_7872 = (baseHeight - 166) / 2 + 3 + row * 18 + yOffset;
            }
        }
    }

    public static void updateEquipmentSlotPosition(class_1703 menu, int baseHeight, int xOffset, int yOffset) {
        for (class_1735 slot : menu.field_7761) {
            if (!(slot instanceof EquipPackSlot)) continue;
            slot.field_7873 = 77 + xOffset;
            slot.field_7872 = (baseHeight - 166) / 2 + 8 + 36 + yOffset;
            break;
        }
    }

    public static void addBackpackSlots(class_1703 screenHandler, class_1661 container) {
        for (int column = 0; column < 6; ++column) {
            for (int row = 0; row < 9; ++row) {
                int columnIndex = column;
                screenHandler.method_7621((class_1735)new BackPackSlot(screenHandler, container, row + (column + 1) * 9 + 27, columnIndex, -25 - column * 18, 3 + row * 18));
            }
        }
    }

    public static boolean isTrinketModLoaded() {
        return BackpackHelper.isModLoaded("trinkets") || BackpackHelper.isModLoaded("curios") || BackpackHelper.isModLoaded("accessories");
    }

    public static void renderEquippackSlot(class_1723 menu, class_332 guiGraphics, int x, int y) {
        if (BackpackManager.isTrinketModLoaded() && !Backpack.getConfig().force_slot) {
            return;
        }
        guiGraphics.method_25290(SLOT_TEXTURE, x + ((BackpackCondition)menu).getEquippackXOffset(), y + ((BackpackCondition)menu).getEquippackYOffset(), 0.0f, 0.0f, 18, 18, 18, 18);
    }

    public static void addEquippackSlot(class_1703 screenHandler, class_1661 inventory) {
        if (BackpackManager.isTrinketModLoaded() && !Backpack.getConfig().force_slot) {
            return;
        }
        screenHandler.method_7621((class_1735)new EquipPackSlot((class_1263)inventory, 90, 77, 44));
    }

    public static void saveBackpackContents(class_1263 inventory, class_1799 backpackStack, boolean b) {
        BackpackItem backpackItem = (BackpackItem)backpackStack.method_7909();
        int columns = backpackItem.getBackpackType().getColumns();
        int numSlots = columns * 9;
        class_2499 itemsTag = new class_2499();
        for (int i = 0; i < numSlots; ++i) {
            int slotIndex = 36 + i;
            class_1799 stack = inventory.method_5438(slotIndex);
            if (stack.method_7960()) continue;
            class_2487 itemTag = new class_2487();
            itemTag.method_10569("Slot", i);
            stack.method_7953(itemTag);
            itemsTag.add((Object)itemTag);
            if (!b) continue;
            inventory.method_5447(slotIndex, class_1799.field_8037);
        }
        class_2487 nbt = backpackStack.method_7948();
        nbt.method_10566("BackpackItems", (class_2520)itemsTag);
    }

    public static void restoreBackpackContents(class_1263 inventory, class_1799 backpackStack) {
        class_2487 nbt = backpackStack.method_7969();
        if (nbt == null || !nbt.method_10573("BackpackItems", 9)) {
            return;
        }
        BackpackItem backpackItem = (BackpackItem)backpackStack.method_7909();
        int columns = backpackItem.getBackpackType().getColumns();
        int numSlots = columns * 9;
        class_2499 itemsTag = nbt.method_10554("BackpackItems", 10);
        for (int i = 0; i < itemsTag.size(); ++i) {
            class_2487 itemTag = itemsTag.method_10602(i);
            int slotIndex = itemTag.method_10550("Slot");
            if (slotIndex < 0 || slotIndex >= numSlots) continue;
            class_1799 stack = class_1799.method_7915((class_2487)itemTag);
            inventory.method_5447(36 + slotIndex, stack);
        }
        nbt.method_10551("BackpackItems");
        if (nbt.method_33133()) {
            backpackStack.method_7980(null);
        }
    }

    public static void renderBackpackBackground(class_332 context, int x, int y, int backgroundWidth, int backgroundHeight, class_1661 inventory, boolean shouldRenderBackpack, BackpackCondition renderCondition) {
        if (!shouldRenderBackpack) {
            return;
        }
        int columns = 0;
        class_1799 stack = BackpackHelper.getEquipped(inventory.field_7546);
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof BackpackItem) {
            BackpackItem backpackItem = (BackpackItem)class_17922;
            columns = backpackItem.getBackpackType().getColumns();
        }
        int width = 14 + columns * 18;
        int left = x - 14 - columns * 18 - 1 + renderCondition.getBackpackXOffset();
        int top = y + (backgroundHeight - 174) / 2 + renderCondition.getBackpackYOffset();
        int u = 14 * (columns - 1) + 18 * (columns - 1) * columns / 2;
        context.method_25290(BACKPACK_TEXTURE, left, top, (float)u, 0.0f, width, 174, 462, 174);
    }

    public static boolean shouldRenderBackpackExtension(class_1703 handler, class_1661 inventory) {
        if (inventory != null && ((BackpackCondition)handler).shouldRenderBackpack()) {
            class_1799 backpackStack = BackpackHelper.getEquipped(inventory.field_7546);
            return backpackStack.method_7909() instanceof BackpackItem;
        }
        return false;
    }

    public static boolean isClickOutsideExtendedBounds(class_1661 inventory, boolean outsideOriginalBounds, double mouseX, double mouseY, int left, int top, int backgroundWidth, int backgroundHeight, boolean shouldRenderBackpackExtension, BackpackCondition renderCondition) {
        boolean inBackpackArea = false;
        if (shouldRenderBackpackExtension) {
            int columns = 0;
            class_1799 backpackStack = BackpackHelper.getEquipped(inventory.field_7546);
            class_1792 class_17922 = backpackStack.method_7909();
            if (class_17922 instanceof BackpackItem) {
                BackpackItem backpack = (BackpackItem)class_17922;
                columns = backpack.getBackpackType().getColumns();
            }
            int backpackWidth = 14 + columns * 18;
            int backpackX = left - backpackWidth - 1 + renderCondition.getBackpackXOffset();
            int backpackY = top + (backgroundHeight - 174) / 2 + renderCondition.getBackpackYOffset();
            int backpackHeight = 174;
            inBackpackArea = mouseX >= (double)backpackX && mouseX < (double)(backpackX + backpackWidth) && mouseY >= (double)backpackY && mouseY < (double)(backpackY + backpackHeight);
        }
        return outsideOriginalBounds && !inBackpackArea;
    }

    public static class Ref<T> {
        public T value;

        public Ref(T value) {
            this.value = value;
        }
    }
}

