/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.forge;

import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackHelper;
import com.yyz.yyzsbackpack.forge.compat.curios.CuriosContainerAdapter;
import com.yyz.yyzsbackpack.item.BackpackItem;
import com.yyz.yyzsbackpack.item.BackpackMaterial;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mod(value="yyzsbackpack")
public final class BackpackForge {
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"yyzsbackpack");
    public static final RegistryObject<CreativeModeTab> BACKPACK_TAB = TABS.register("backpack_tab", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)GOLD_BACKPACK.get())).m_257941_((Component)Component.m_237115_((String)"itemGroup.yyzsbackpack.title")).m_257501_((context, entries) -> {
        entries.m_246326_((ItemLike)WOOLEN_BACKPACK.get());
        entries.m_246326_((ItemLike)STONE_BACKPACK.get());
        entries.m_246326_((ItemLike)IRON_BACKPACK.get());
        entries.m_246326_((ItemLike)GOLD_BACKPACK.get());
        entries.m_246326_((ItemLike)DIAMOND_BACKPACK.get());
        entries.m_246326_((ItemLike)NETHERITE_BACKPACK.get());
    }).m_257652_());
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"yyzsbackpack");
    public static final RegistryObject<Item> NETHERITE_BACKPACK = ITEMS.register("netherite_backpack", () -> new BackpackItem(BackpackMaterial.NETHERITE, new Item.Properties().m_41487_(1).m_41486_()));
    public static final RegistryObject<Item> DIAMOND_BACKPACK = ITEMS.register("diamond_backpack", () -> new BackpackItem(BackpackMaterial.DIAMOND, new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> GOLD_BACKPACK = ITEMS.register("gold_backpack", () -> new BackpackItem(BackpackMaterial.GOLD, new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> IRON_BACKPACK = ITEMS.register("iron_backpack", () -> new BackpackItem(BackpackMaterial.IRON, new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> STONE_BACKPACK = ITEMS.register("stone_backpack", () -> new BackpackItem(BackpackMaterial.STONE, new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> WOOLEN_BACKPACK = ITEMS.register("woolen_backpack", () -> new BackpackItem(BackpackMaterial.WOOLEN, new Item.Properties().m_41487_(1)));

    public BackpackForge() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        TABS.register(modEventBus);
        ITEMS.register(modEventBus);
        Backpack.init();
    }

    public static ItemStack getEquipped(Player player) {
        Optional backpackSlot;
        Optional curiosHandler;
        if (BackpackHelper.isModLoaded("curios") && (curiosHandler = CuriosApi.getCuriosInventory((LivingEntity)player).resolve()).isPresent() && (backpackSlot = ((ICuriosItemHandler)curiosHandler.get()).findFirstCurio(stack -> stack.m_41720_() instanceof BackpackItem)).isPresent()) {
            return ((SlotResult)backpackSlot.get()).stack();
        }
        return player.m_150109_().m_8020_(36);
    }

    public static Container getContainer(Player player) {
        Optional backpackSlot;
        Optional curiosHandler;
        if (BackpackHelper.isModLoaded("curios") && (curiosHandler = CuriosApi.getCuriosInventory((LivingEntity)player).resolve()).isPresent() && (backpackSlot = ((ICuriosItemHandler)curiosHandler.get()).findFirstCurio(stack -> stack.m_41720_() instanceof BackpackItem)).isPresent()) {
            String slotId = ((SlotResult)backpackSlot.get()).slotContext().identifier();
            int slotIndex = ((SlotResult)backpackSlot.get()).slotContext().index();
            Optional stacksHandler = ((ICuriosItemHandler)curiosHandler.get()).getStacksHandler(slotId);
            if (stacksHandler.isPresent()) {
                return new CuriosContainerAdapter(((ICurioStacksHandler)stacksHandler.get()).getStacks(), slotIndex);
            }
        }
        return player.m_150109_();
    }

    public static int getIndex(Player player) {
        CuriosContainerAdapter container;
        Optional backpackSlot;
        Optional curiosHandler;
        if (BackpackHelper.isModLoaded("curios") && (curiosHandler = CuriosApi.getCuriosInventory((LivingEntity)player).resolve()).isPresent() && (backpackSlot = ((ICuriosItemHandler)curiosHandler.get()).findFirstCurio(stack -> stack.m_41720_() instanceof BackpackItem)).isPresent() && (container = (CuriosContainerAdapter)BackpackForge.getContainer(player)) != null) {
            return container.getBackpackSlotIndex();
        }
        return 36;
    }
}

