/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.mixin;

import com.yyz.yyzsbackpack.BackpackHelper;
import com.yyz.yyzsbackpack.BackpackManager;
import com.yyz.yyzsbackpack.api.BackPackSlot;
import com.yyz.yyzsbackpack.api.BackpackRenderCondition;
import com.yyz.yyzsbackpack.item.BackpackItem;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractContainerMenu.class}, priority=999)
public abstract class ScreenHandlerMixin
implements BackpackRenderCondition {
    @Shadow
    @Final
    public NonNullList<Slot> slots;
    @Unique
    private boolean shouldRenderBackpack = false;
    @Unique
    private int backpackXOffset = 0;
    @Unique
    private int backpackYOffset = 0;
    @Unique
    private int equippackXOffset = 0;
    @Unique
    private int equippackYOffset = 0;

    @Shadow
    public abstract ItemStack getCarried();

    @Shadow
    public abstract void setCarried(ItemStack var1);

    @Shadow
    public abstract Slot getSlot(int var1);

    @Shadow
    protected abstract boolean moveItemStackTo(ItemStack var1, int var2, int var3, boolean var4);

    @Override
    public boolean shouldRenderBackpack() {
        return this.shouldRenderBackpack;
    }

    @Override
    public void setRenderBackpack(boolean shouldRenderBackpack) {
        this.shouldRenderBackpack = shouldRenderBackpack;
    }

    @Override
    public int getBackpackXOffset() {
        return this.backpackXOffset;
    }

    @Override
    public int getBackpackYOffset() {
        return this.backpackYOffset;
    }

    @Override
    public void setBackpackOffset(int x, int y) {
        this.backpackXOffset = x;
        this.backpackYOffset = y;
    }

    @Override
    public int getEquippackXOffset() {
        return this.equippackXOffset;
    }

    @Override
    public int getEquippackYOffset() {
        return this.equippackYOffset;
    }

    @Override
    public void setEquippackOffset(int x, int y) {
        this.equippackXOffset = x;
        this.equippackYOffset = y;
    }

    @Inject(method={"addStandardInventorySlots(Lnet/minecraft/world/Container;II)V"}, at={@At(value="RETURN")})
    private void addSlot(Container container, int i, int j, CallbackInfo ci) {
        this.setRenderBackpack(true);
        AbstractContainerMenu containerMenu = (AbstractContainerMenu)this;
        BackpackManager.addBackpackSlots(containerMenu, container);
    }

    @Inject(method={"clicked(IILnet/minecraft/world/inventory/ClickType;Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="RETURN")})
    private void handleBackpackSwap(int slotIndex, int button, ClickType actionType, Player player, CallbackInfo ci) {
        if (slotIndex < 0 || actionType != ClickType.PICKUP || ((Slot)this.slots.get(slotIndex)).getItem().getItem() instanceof BackpackItem) {
            return;
        }
        if (!(this.getSlot(slotIndex) instanceof BackPackSlot)) {
            return;
        }
        ItemStack back = BackpackHelper.getEquipped(player).copy();
        ItemStack stack = this.getCarried().copy();
        if (!(back.getItem() instanceof BackpackItem) || !(stack.getItem() instanceof BackpackItem)) {
            return;
        }
        BackpackManager.saveBackpackContents((Container)player.getInventory(), back);
        BackpackManager.restoreBackpackContents((Container)player.getInventory(), stack);
        Container container = BackpackHelper.getContainer(player);
        container.setItem(BackpackHelper.getIndex(player), stack);
        this.setCarried(back);
    }

    @Inject(method={"doClick(IILnet/minecraft/world/inventory/ClickType;Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleShiftRightClick(int i, int j, ClickType clickType, Player player, CallbackInfo ci) {
        if (clickType == ClickType.QUICK_MOVE && j == 1) {
            if (i < 0) {
                ci.cancel();
                return;
            }
            Slot slot = (Slot)this.slots.get(i);
            if (!slot.mayPickup(player)) {
                ci.cancel();
                return;
            }
            if (slot instanceof BackPackSlot) {
                ItemStack itemStack = this.quickMoveToHotbar(player, i);
                while (!itemStack.isEmpty() && ItemStack.isSameItem((ItemStack)slot.getItem(), (ItemStack)itemStack)) {
                    itemStack = this.quickMoveToHotbar(player, i);
                }
                ci.cancel();
                return;
            }
            if (i >= 9 && i < 45) {
                ItemStack itemStack = this.quickMoveToBackpack(player, i);
                while (!itemStack.isEmpty() && ItemStack.isSameItem((ItemStack)slot.getItem(), (ItemStack)itemStack)) {
                    itemStack = this.quickMoveToBackpack(player, i);
                }
                ci.cancel();
            }
        }
    }

    @Unique
    private ItemStack quickMoveToHotbar(Player player, int slotIndex) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            if (!this.moveItemStackTo(slotStack, 36, 45, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            slot.onTake(player, slotStack);
        }
        return itemStack;
    }

    @Unique
    private ItemStack quickMoveToBackpack(Player player, int slotIndex) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            int backpackStart = -1;
            for (int i = 0; i < this.slots.size(); ++i) {
                if (!(this.slots.get(i) instanceof BackPackSlot)) continue;
                backpackStart = i;
                break;
            }
            if (backpackStart == -1) {
                return ItemStack.EMPTY;
            }
            if (!this.moveItemStackTo(slotStack, backpackStart, backpackStart + 54, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            slot.onTake(player, slotStack);
        }
        return itemStack;
    }
}

