/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class BackpackConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public boolean quick_swap = true;
    public boolean force_slot = false;
    public int slot_offsetX = 0;
    public int slot_offsetY = 0;
    public int backpack_offsetX = 0;
    public int backpack_offsetY = 0;

    public static BackpackConfig loadConfig(File file) {
        BackpackConfig config;
        block18: {
            if (file.exists() && file.isFile()) {
                try (FileInputStream fileInputStream = new FileInputStream(file);
                     InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
                     BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                    config = (BackpackConfig)GSON.fromJson((Reader)bufferedReader, BackpackConfig.class);
                    break block18;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load config", e);
                }
            }
            config = new BackpackConfig();
        }
        config.saveConfig(file);
        return config;
    }

    public void saveConfig(File config) {
        try (FileOutputStream stream = new FileOutputStream(config);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load config", e);
        }
    }
}

