/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.mixin;

import com.yyz.yyzsbackpack.BackpackHelper;
import com.yyz.yyzsbackpack.BackpackManager;
import com.yyz.yyzsbackpack.api.BackPackSlot;
import com.yyz.yyzsbackpack.api.BackpackCondition;
import com.yyz.yyzsbackpack.api.BackpackExclusionZoneProvider;
import com.yyz.yyzsbackpack.item.BackpackItem;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractContainerScreen.class}, priority=1001)
public abstract class HandledScreenMixin<T extends AbstractContainerMenu>
extends Screen
implements BackpackExclusionZoneProvider {
    @Shadow
    protected int f_97726_;
    @Shadow
    protected int f_97727_;
    @Shadow
    protected int f_97735_;
    @Shadow
    protected int f_97736_;
    @Shadow
    @Final
    protected T f_97732_;
    @Unique
    private Inventory inventory;
    @Unique
    private boolean shouldRenderBackpackExtension = false;
    @Unique
    private boolean previousBackpackState = false;

    @Shadow
    protected abstract boolean m_7467_(double var1, double var3, int var5, int var6, int var7);

    protected HandledScreenMixin(Component title) {
        super(title);
    }

    public void m_280273_(GuiGraphics context) {
        super.m_280273_(context);
        BackpackManager.renderBackpackBackground(context, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_, this.inventory, this.shouldRenderBackpackExtension, (BackpackCondition)this.f_97732_);
    }

    @ModifyConstant(method={"checkHotbarMouseClicked"}, constant={@Constant(intValue=40)})
    private int adjustOffhandSlotPosition(int original) {
        return 95;
    }

    @ModifyConstant(method={"checkHotbarKeyPressed"}, constant={@Constant(intValue=40)})
    private int adjustOffhandSlotPositionHotbar(int original) {
        return 95;
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void checkBackpackStateChange(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        boolean currentState = BackpackManager.shouldRenderBackpackExtension(this.f_97732_, this.inventory);
        if (currentState != this.previousBackpackState) {
            this.shouldRenderBackpackExtension = currentState;
            this.previousBackpackState = currentState;
            this.m_232761_();
        }
    }

    @Redirect(method={"mouseClicked"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;hasClickedOutside(DDIII)Z"))
    private boolean handleMouseClicked(AbstractContainerScreen<?> instance, double mouseX, double mouseY, int left, int top, int button) {
        return this.f_97732_ instanceof BackpackCondition ? BackpackManager.isClickOutsideExtendedBounds(this.inventory, this.m_7467_(mouseX, mouseY, this.f_97735_, this.f_97736_, button), mouseX, mouseY, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_, this.shouldRenderBackpackExtension, (BackpackCondition)this.f_97732_) : this.m_7467_(mouseX, mouseY, this.f_97735_, this.f_97736_, button);
    }

    @Redirect(method={"mouseReleased"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;hasClickedOutside(DDIII)Z"))
    private boolean handleMouseReleased(AbstractContainerScreen<?> instance, double mouseX, double mouseY, int left, int top, int button) {
        return this.f_97732_ instanceof BackpackCondition ? BackpackManager.isClickOutsideExtendedBounds(this.inventory, this.m_7467_(mouseX, mouseY, this.f_97735_, this.f_97736_, button), mouseX, mouseY, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_, this.shouldRenderBackpackExtension, (BackpackCondition)this.f_97732_) : this.m_7467_(mouseX, mouseY, this.f_97735_, this.f_97736_, button);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void initializeFields(AbstractContainerMenu handler, Inventory inventory, Component component, CallbackInfo ci) {
        this.inventory = inventory;
        this.previousBackpackState = this.shouldRenderBackpackExtension = BackpackManager.shouldRenderBackpackExtension(handler, this.inventory);
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void updateBackpackSlotsPositionBeforeRender(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        Screen screen = this;
        if (screen instanceof CreativeModeInventoryScreen) {
            return;
        }
        if (this.f_97732_ instanceof BackpackCondition) {
            int baseHeight = this.f_97727_;
            int backpackSlotStartIndex = -1;
            for (int i = 0; i < ((AbstractContainerMenu)this.f_97732_).f_38839_.size(); ++i) {
                if (!(((AbstractContainerMenu)this.f_97732_).f_38839_.get(i) instanceof BackPackSlot)) continue;
                backpackSlotStartIndex = i;
                break;
            }
            if (backpackSlotStartIndex == -1) {
                return;
            }
            int xOffset = ((BackpackCondition)this.f_97732_).getBackpackXOffset();
            int yOffset = ((BackpackCondition)this.f_97732_).getBackpackYOffset();
            int xOffset1 = ((BackpackCondition)this.f_97732_).getEquippackXOffset();
            int yOffset1 = ((BackpackCondition)this.f_97732_).getEquippackYOffset();
            BackpackManager.updateBackpackSlotsPosition(this.f_97732_, backpackSlotStartIndex, baseHeight, xOffset, yOffset);
            BackpackManager.updateEquipmentSlotPosition(this.f_97732_, baseHeight, xOffset1, yOffset1);
        }
    }

    @Override
    public List<Rect2i> getBackpackExclusionZones() {
        int xOffset = ((BackpackCondition)this.f_97732_).getBackpackXOffset();
        int yOffset = ((BackpackCondition)this.f_97732_).getBackpackYOffset();
        if (!this.shouldRenderBackpackExtension) {
            return Collections.emptyList();
        }
        int columns = 0;
        ItemStack backpackStack = BackpackHelper.getEquipped(this.inventory.f_35978_);
        Item item = backpackStack.m_41720_();
        if (item instanceof BackpackItem) {
            BackpackItem backpack = (BackpackItem)item;
            columns = backpack.getBackpackType().getColumns();
        }
        int baseWidth = 14 + columns * 18;
        int height = 174;
        int x = this.f_97735_ - baseWidth - 1 + xOffset;
        int y = this.f_97736_ + (this.f_97727_ - height) / 2 + yOffset;
        int actualWidth = baseWidth;
        if (xOffset != 0) {
            actualWidth = xOffset > 0 ? (actualWidth += xOffset) : (actualWidth -= xOffset);
            actualWidth = Math.max(actualWidth, baseWidth);
        }
        return Collections.singletonList(new Rect2i(x, y, actualWidth, height));
    }
}

