/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.base;

import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackPlatform;
import com.yyz.yyzsbackpack.base.BackpackMenu;
import com.yyz.yyzsbackpack.item.BackpackItem;
import com.yyz.yyzsbackpack.util.BackpackHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BackpackStorageSlot
extends Slot {
    private final AbstractContainerMenu menu;
    private final Inventory inventory;
    private final int slotIndex;

    public BackpackStorageSlot(AbstractContainerMenu menu, Inventory inventory, int index, int j, int k) {
        super((Container)inventory, index, j, k);
        this.menu = menu;
        this.inventory = inventory;
        this.slotIndex = index;
    }

    public boolean isActive() {
        ItemStack backpackStack = BackpackPlatform.getEquipped(this.inventory.player);
        Item item = backpackStack.getItem();
        if (!(item instanceof BackpackItem)) {
            return false;
        }
        BackpackItem backpackItem = (BackpackItem)item;
        int size = backpackItem.getBackpackType().getSize();
        if (this.slotIndex >= size + 36) {
            return false;
        }
        return ((BackpackMenu)this.menu).isBackpackVisible();
    }

    public boolean mayPlace(ItemStack stack) {
        BackpackItem backpackItem;
        int size;
        ItemStack backpackStack = BackpackPlatform.getEquipped(this.inventory.player);
        boolean canPlace = !(stack.getItem() instanceof BackpackItem) && backpackStack.getItem() instanceof BackpackItem && super.mayPlace(stack);
        Item item = backpackStack.getItem();
        if (item instanceof BackpackItem && this.slotIndex >= (size = (backpackItem = (BackpackItem)item).getBackpackType().getSize()) + 36) {
            return false;
        }
        if (BackpackHelper.isItemBlacklisted(stack.getItem())) {
            return false;
        }
        if (!stack.getItem().canFitInsideContainerItems() && Backpack.getConfig().restrict_container_items) {
            return false;
        }
        return canPlace;
    }
}

