/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackPlatform;
import com.yyz.yyzsbackpack.base.BackpackEffect;
import com.yyz.yyzsbackpack.config.BackpackConfig;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class BackpackCommand {
    private static final String[] MODIFIER_SUGGESTIONS = new String[]{"shift", "alt", "ctrl", "none"};

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"yyzsbackpack").requires(source -> source.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"config").then(Commands.literal((String)"quick_swap_backpack").then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> BackpackCommand.setBoolean((CommandContext<CommandSourceStack>)ctx, "quick_swap_backpack"))))).then(Commands.literal((String)"use_dedicated_slot").then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> BackpackCommand.setBoolean((CommandContext<CommandSourceStack>)ctx, "use_dedicated_slot"))))).then(Commands.literal((String)"render_backpack_model").then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> BackpackCommand.setBoolean((CommandContext<CommandSourceStack>)ctx, "render_backpack_model"))))).then(Commands.literal((String)"restrict_container_items").then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> BackpackCommand.setBoolean((CommandContext<CommandSourceStack>)ctx, "restrict_container_items"))))).then(Commands.literal((String)"slot_position_x").then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> BackpackCommand.setInt((CommandContext<CommandSourceStack>)ctx, "slot_position_x"))))).then(Commands.literal((String)"slot_position_y").then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> BackpackCommand.setInt((CommandContext<CommandSourceStack>)ctx, "slot_position_y"))))).then(Commands.literal((String)"backpack_gui_x").then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> BackpackCommand.setInt((CommandContext<CommandSourceStack>)ctx, "backpack_gui_x"))))).then(Commands.literal((String)"backpack_gui_y").then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> BackpackCommand.setInt((CommandContext<CommandSourceStack>)ctx, "backpack_gui_y"))))).then(Commands.literal((String)"tooltip_modifier").then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest((String[])MODIFIER_SUGGESTIONS, (SuggestionsBuilder)builder)).executes(BackpackCommand::setTipKey)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"restricted_items").then(Commands.literal((String)"add").then(Commands.argument((String)"item", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> BackpackCommand.suggestAllItems((CommandSourceStack)context.getSource(), builder)).executes(BackpackCommand::addItem)))).then(Commands.literal((String)"remove").then(Commands.argument((String)"item", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> BackpackCommand.suggestConfiguredItems((CommandSourceStack)context.getSource(), builder)).executes(BackpackCommand::removeItem)))).then(Commands.literal((String)"clear").executes(BackpackCommand::clearItems)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"backpack_multi_effects").then(Commands.literal((String)"set").then(Commands.argument((String)"tier", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.argument((String)"effect", (ArgumentType)StringArgumentType.string()).suggests(BackpackCommand::suggestEffectTypes).then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(BackpackCommand::setEffect)))))).then(Commands.literal((String)"add").then(Commands.argument((String)"effect", (ArgumentType)StringArgumentType.string()).suggests(BackpackCommand::suggestEffectTypes).then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(BackpackCommand::addEffect))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"tier", (ArgumentType)IntegerArgumentType.integer((int)0)).suggests(BackpackCommand::suggestEffectTiers).executes(BackpackCommand::removeEffect)))).then(Commands.literal((String)"clear").executes(BackpackCommand::clearEffects)))).then(Commands.literal((String)"reload").executes(BackpackCommand::reloadConfig))));
    }

    private static int setBoolean(CommandContext<CommandSourceStack> ctx, String property) {
        boolean value = BoolArgumentType.getBool(ctx, (String)"value");
        BackpackCommand.setProperty(property, value);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.yyzsbackpack.set.boolean", (Object[])new Object[]{property, String.valueOf(value)}), true);
        return 1;
    }

    private static int setInt(CommandContext<CommandSourceStack> ctx, String property) {
        int value = IntegerArgumentType.getInteger(ctx, (String)"value");
        BackpackCommand.setProperty(property, value);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.yyzsbackpack.set.integer", (Object[])new Object[]{property, value}), true);
        return 1;
    }

    private static int setTipKey(CommandContext<CommandSourceStack> ctx) {
        String value = StringArgumentType.getString(ctx, (String)"value");
        if (!Set.of("shift", "alt", "ctrl", "none").contains(value)) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.yyzsbackpack.set.tooltip_modifier.invalid"));
            return 0;
        }
        BackpackCommand.setProperty("tooltip_modifier", value);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.yyzsbackpack.set.tooltip_modifier", (Object[])new Object[]{value}), true);
        return 1;
    }

    private static void setProperty(String name, Object value) {
        BackpackConfig config = Backpack.getConfig();
        try {
            config.getClass().getField(name).set(config, value);
            config.saveConfig(new File(String.valueOf(BackpackPlatform.getConfigDirectory().resolve("yyzsbackpack")) + "/yyzsbackpack.json"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static int addItem(CommandContext<CommandSourceStack> ctx) {
        String item = StringArgumentType.getString(ctx, (String)"item");
        BackpackConfig config = Backpack.getConfig();
        if (config.restricted_items.add(item)) {
            config.saveConfig(new File(String.valueOf(BackpackPlatform.getConfigDirectory().resolve("yyzsbackpack")) + "/yyzsbackpack.json"));
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.yyzsbackpack.restricted_items.add", (Object[])new Object[]{item}), true);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.yyzsbackpack.restricted_items.exists"));
        return 0;
    }

    private static int removeItem(CommandContext<CommandSourceStack> ctx) {
        String item = StringArgumentType.getString(ctx, (String)"item");
        BackpackConfig config = Backpack.getConfig();
        if (config.restricted_items.remove(item)) {
            config.saveConfig(new File(String.valueOf(BackpackPlatform.getConfigDirectory().resolve("yyzsbackpack")) + "/yyzsbackpack.json"));
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.yyzsbackpack.restricted_items.remove", (Object[])new Object[]{item}), true);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.yyzsbackpack.restricted_items.not_found"));
        return 0;
    }

    private static int clearItems(CommandContext<CommandSourceStack> ctx) {
        BackpackConfig config = Backpack.getConfig();
        config.restricted_items.clear();
        config.saveConfig(new File(String.valueOf(BackpackPlatform.getConfigDirectory().resolve("yyzsbackpack")) + "/yyzsbackpack.json"));
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.yyzsbackpack.restricted_items.clear"), true);
        return 1;
    }

    private static int reloadConfig(CommandContext<CommandSourceStack> ctx) {
        Backpack.init();
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.yyzsbackpack.reload"), true);
        return 1;
    }

    private static CompletableFuture<Suggestions> suggestAllItems(CommandSourceStack source, SuggestionsBuilder builder) {
        Set itemIds = BuiltInRegistries.ITEM.keySet();
        ArrayList<CallSite> quotedSuggestions = new ArrayList<CallSite>();
        for (ResourceLocation id : itemIds) {
            quotedSuggestions.add((CallSite)((Object)("\"" + id.toString() + "\"")));
        }
        return SharedSuggestionProvider.suggest(quotedSuggestions, (SuggestionsBuilder)builder.createOffset(builder.getStart()));
    }

    private static CompletableFuture<Suggestions> suggestConfiguredItems(CommandSourceStack source, SuggestionsBuilder builder) {
        Set<String> configuredItems = Backpack.getConfig().restricted_items;
        ArrayList<CallSite> quotedSuggestions = new ArrayList<CallSite>();
        for (String item : configuredItems) {
            quotedSuggestions.add((CallSite)((Object)("\"" + item + "\"")));
        }
        return SharedSuggestionProvider.suggest(quotedSuggestions, (SuggestionsBuilder)builder.createOffset(builder.getStart()));
    }

    private static int setEffect(CommandContext<CommandSourceStack> ctx) {
        int tier = IntegerArgumentType.getInteger(ctx, (String)"tier");
        String effect = StringArgumentType.getString(ctx, (String)"effect");
        int level = IntegerArgumentType.getInteger(ctx, (String)"level");
        BackpackConfig config = Backpack.getConfig();
        List<BackpackEffect> effects = config.backpack_multi_effects;
        while (effects.size() <= tier) {
            effects.add(new BackpackEffect("none", 0));
        }
        BackpackEffect be = effects.get(tier);
        be.effectType = effect;
        be.amplifier = level;
        config.saveConfig(new File(String.valueOf(BackpackPlatform.getConfigDirectory().resolve("yyzsbackpack")) + "/yyzsbackpack.json"));
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.yyzsbackpack.effect.set", (Object[])new Object[]{tier, effect, level}), true);
        return 1;
    }

    private static int addEffect(CommandContext<CommandSourceStack> ctx) {
        String effect = StringArgumentType.getString(ctx, (String)"effect");
        int level = IntegerArgumentType.getInteger(ctx, (String)"level");
        BackpackConfig config = Backpack.getConfig();
        config.backpack_multi_effects.add(new BackpackEffect(effect, level));
        config.saveConfig(new File(String.valueOf(BackpackPlatform.getConfigDirectory().resolve("yyzsbackpack")) + "/yyzsbackpack.json"));
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.yyzsbackpack.effect.add", (Object[])new Object[]{effect, level}), true);
        return 1;
    }

    private static int removeEffect(CommandContext<CommandSourceStack> ctx) {
        int tier = IntegerArgumentType.getInteger(ctx, (String)"tier");
        BackpackConfig config = Backpack.getConfig();
        List<BackpackEffect> effects = config.backpack_multi_effects;
        if (tier >= effects.size()) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"command.yyzsbackpack.effect.invalid_tier", (Object[])new Object[]{effects.size() - 1}));
            return 0;
        }
        effects.remove(tier);
        config.saveConfig(new File(String.valueOf(BackpackPlatform.getConfigDirectory().resolve("yyzsbackpack")) + "/yyzsbackpack.json"));
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.yyzsbackpack.effect.remove", (Object[])new Object[]{tier}), true);
        return 1;
    }

    private static int clearEffects(CommandContext<CommandSourceStack> ctx) {
        BackpackConfig config = Backpack.getConfig();
        config.backpack_multi_effects.clear();
        config.saveConfig(new File(String.valueOf(BackpackPlatform.getConfigDirectory().resolve("yyzsbackpack")) + "/yyzsbackpack.json"));
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"command.yyzsbackpack.effect.clear"), true);
        return 1;
    }

    private static CompletableFuture<Suggestions> suggestEffectTypes(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        ArrayList<String> suggestions = new ArrayList<String>();
        suggestions.add("\"none\"");
        BuiltInRegistries.MOB_EFFECT.keySet().forEach(id -> suggestions.add("\"" + id.toString() + "\""));
        return SharedSuggestionProvider.suggest(suggestions, (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> suggestEffectTiers(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        BackpackConfig config = Backpack.getConfig();
        ArrayList<String> tiers = new ArrayList<String>();
        for (int i = 0; i < config.backpack_multi_effects.size(); ++i) {
            tiers.add(String.valueOf(i));
        }
        return SharedSuggestionProvider.suggest(tiers, (SuggestionsBuilder)builder);
    }
}

