/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.neoforge;

import com.mojang.serialization.Codec;
import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackPlatform;
import com.yyz.yyzsbackpack.compat.accessories.AccessoriesContainerAdapter;
import com.yyz.yyzsbackpack.item.BackpackItem;
import com.yyz.yyzsbackpack.neoforge.compat.curios.CuriosContainerAdapter;
import com.yyz.yyzsbackpack.util.BackpackHelper;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.impl.core.ExpandedContainer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mod(value="yyzsbackpack")
public final class BackpackNeoForge {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"yyzsbackpack");
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"yyzsbackpack");
    public static final DeferredRegister.DataComponents DATA_COMPONENT = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"yyzsbackpack");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> BACKPACK_TAB = TABS.register("backpack_tab", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)GOLD_BACKPACK.get())).title((Component)Component.translatable((String)"itemGroup.yyzsbackpack.title")).displayItems((context, entries) -> {
        entries.accept((ItemLike)IRON_BACKPACK.get());
        entries.accept((ItemLike)GOLD_BACKPACK.get());
        entries.accept((ItemLike)DIAMOND_BACKPACK.get());
        entries.accept((ItemLike)NETHERITE_BACKPACK.get());
    }).build());
    public static final DeferredItem<Item> NETHERITE_BACKPACK = ITEMS.registerItem("netherite_backpack", props -> new BackpackItem("netherite", (Item.Properties)props), new Item.Properties().stacksTo(1).fireResistant());
    public static final DeferredItem<Item> DIAMOND_BACKPACK = ITEMS.registerItem("diamond_backpack", props -> new BackpackItem("diamond", (Item.Properties)props), new Item.Properties().stacksTo(1));
    public static final DeferredItem<Item> GOLD_BACKPACK = ITEMS.registerItem("gold_backpack", props -> new BackpackItem("gold", (Item.Properties)props), new Item.Properties().stacksTo(1));
    public static final DeferredItem<Item> IRON_BACKPACK = ITEMS.registerItem("iron_backpack", props -> new BackpackItem("iron", (Item.Properties)props), new Item.Properties().stacksTo(1));
    public static final Supplier<DataComponentType<List<ItemStack>>> BACKPACK_ITEMS_COMPONENT = DATA_COMPONENT.registerComponentType("backpack_items", builder -> builder.persistent(Codec.list((Codec)ItemStack.OPTIONAL_CODEC)));

    public BackpackNeoForge(IEventBus modEventBus, ModContainer modContainer) {
        ITEMS.register(modEventBus);
        TABS.register(modEventBus);
        DATA_COMPONENT.register(modEventBus);
        Backpack.init();
    }

    public static ItemStack getEquipped(Player player) {
        if (!Backpack.getConfig().use_dedicated_slot) {
            AccessoriesCapability capability;
            Optional backpackSlot;
            Optional curiosHandler;
            if (BackpackPlatform.isModLoaded("curios") && (curiosHandler = CuriosApi.getCuriosInventory((LivingEntity)player)).isPresent() && (backpackSlot = ((ICuriosItemHandler)curiosHandler.get()).findFirstCurio(stack -> stack.getItem() instanceof BackpackItem)).isPresent()) {
                return ((SlotResult)backpackSlot.get()).stack();
            }
            if (BackpackPlatform.isModLoaded("accessories") && !BackpackPlatform.isModLoaded("curios") && (capability = AccessoriesCapability.get((LivingEntity)player)) != null) {
                Map containers = capability.getContainers();
                for (AccessoriesContainer container : containers.values()) {
                    ExpandedContainer accessoriesContainer = container.getAccessories();
                    for (int i = 0; i < accessoriesContainer.getContainerSize(); ++i) {
                        ItemStack stack2 = accessoriesContainer.getItem(i);
                        if (!(stack2.getItem() instanceof BackpackItem)) continue;
                        return stack2;
                    }
                }
            }
        }
        return player.getInventory().getItem(36 + BackpackHelper.getMaxBackpackSize());
    }

    public static Container getContainer(Player player) {
        if (!Backpack.getConfig().use_dedicated_slot) {
            AccessoriesCapability capability;
            Optional backpackSlot;
            Optional curiosHandler;
            if (BackpackPlatform.isModLoaded("curios") && (curiosHandler = CuriosApi.getCuriosInventory((LivingEntity)player)).isPresent() && (backpackSlot = ((ICuriosItemHandler)curiosHandler.get()).findFirstCurio(stack -> stack.getItem() instanceof BackpackItem)).isPresent()) {
                SlotContext slotContext = ((SlotResult)backpackSlot.get()).slotContext();
                String slotId = slotContext.identifier();
                int slotIndex = slotContext.index();
                Optional stacksHandler = ((ICuriosItemHandler)curiosHandler.get()).getStacksHandler(slotId);
                if (stacksHandler.isPresent()) {
                    return new CuriosContainerAdapter(((ICurioStacksHandler)stacksHandler.get()).getStacks(), slotIndex);
                }
            }
            if (BackpackPlatform.isModLoaded("accessories") && !BackpackPlatform.isModLoaded("curios") && (capability = AccessoriesCapability.get((LivingEntity)player)) != null) {
                Map containers = capability.getContainers();
                for (AccessoriesContainer container : containers.values()) {
                    ExpandedContainer accessoriesContainer = container.getAccessories();
                    for (int i = 0; i < accessoriesContainer.getContainerSize(); ++i) {
                        ItemStack stack2 = accessoriesContainer.getItem(i);
                        if (!(stack2.getItem() instanceof BackpackItem)) continue;
                        return new AccessoriesContainerAdapter((Container)accessoriesContainer, i);
                    }
                }
            }
        }
        return player.getInventory();
    }

    public static int getIndex(Player player) {
        if (!Backpack.getConfig().use_dedicated_slot) {
            Container container;
            Container container2;
            Optional backpackSlot;
            Optional curiosHandler;
            if (BackpackPlatform.isModLoaded("curios") && (curiosHandler = CuriosApi.getCuriosInventory((LivingEntity)player)).isPresent() && (backpackSlot = ((ICuriosItemHandler)curiosHandler.get()).findFirstCurio(stack -> stack.getItem() instanceof BackpackItem)).isPresent() && (container2 = BackpackNeoForge.getContainer(player)) instanceof CuriosContainerAdapter) {
                return ((CuriosContainerAdapter)container2).getBackpackSlotIndex();
            }
            if (BackpackPlatform.isModLoaded("accessories") && !BackpackPlatform.isModLoaded("curios") && (container = BackpackNeoForge.getContainer(player)) instanceof AccessoriesContainerAdapter) {
                return ((AccessoriesContainerAdapter)container).getBackpackSlotIndex();
            }
        }
        return 36 + BackpackHelper.getMaxBackpackSize();
    }
}

