/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.yyz.yyzsbackpack.BackpackHelper;
import com.yyz.yyzsbackpack.item.BackpackItem;
import java.util.Random;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class BackpackFeatureRenderer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private final ModelPart backpack;
    private final Random random = new Random();

    public BackpackFeatureRenderer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> context) {
        super(context);
        this.backpack = this.createBackpackModel();
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, AbstractClientPlayer entity, float f, float g, float h, float j, float k, float l) {
        if (this.shouldRender((Player)entity)) {
            this.renderShield(poseStack, multiBufferSource, (Player)entity, i, h);
        }
    }

    private ModelPart createBackpackModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition backpack = partdefinition.addOrReplaceChild("backpack", CubeListBuilder.create().texOffs(38, 27).addBox(-5.0f, -14.5f, -4.0f, 10.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-6.0f, -14.0f, -5.0f, 12.0f, 14.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 19).addBox(-5.0f, -5.0f, 0.0f, 10.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(12, 31).addBox(-4.0f, -12.0f, 0.0f, 8.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(22, 19).addBox(-6.9f, -7.0f, -5.0f, 1.0f, 7.0f, 5.0f, new CubeDeformation(-0.1f)).texOffs(34, 0).addBox(-7.5f, -6.0f, -4.0f, 1.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(34, 0).addBox(-6.7f, -13.0f, -4.0f, 1.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(34, 8).addBox(5.7f, -13.0f, -4.0f, 1.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 25).addBox(5.9f, -7.0f, -5.0f, 1.0f, 7.0f, 5.0f, new CubeDeformation(-0.1f)).texOffs(34, 8).addBox(6.5f, -6.0f, -4.0f, 1.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(38, 23).addBox(-5.0f, -0.5f, -4.0f, 10.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(30, 31).addBox(-2.0f, -8.0f, -1.0f, 4.0f, 3.0f, 2.0f, new CubeDeformation(-0.3f)).texOffs(42, 32).addBox(0.0f, -3.5f, 0.25f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)14.0f, (float)8.0f));
        return meshdefinition.getRoot().bake(64, 64).getChild("backpack");
    }

    private boolean shouldRender(Player player) {
        return BackpackHelper.getEquipped(player).getItem() instanceof BackpackItem;
    }

    private ResourceLocation getTexture(Player player) {
        Item item = BackpackHelper.getEquipped(player).getItem();
        if (item instanceof BackpackItem) {
            BackpackItem backpackItem = (BackpackItem)item;
            return ResourceLocation.fromNamespaceAndPath((String)"yyzsbackpack", (String)("textures/backpack/" + backpackItem.getBackpackType().getType() + "_backpack.png"));
        }
        return ResourceLocation.fromNamespaceAndPath((String)"yyzsbackpack", (String)"textures/backpack/gold_backpack.png");
    }

    private void renderShield(PoseStack matrices, MultiBufferSource vertexConsumers, Player player, int light, float tickDelta) {
        matrices.pushPose();
        matrices.scale(0.8f, 0.8f, 0.8f);
        if (player.isCrouching()) {
            matrices.translate(0.0f, 0.3f, 0.0f);
            matrices.mulPose(Axis.XP.rotationDegrees(30.0f));
        }
        VertexConsumer vertexConsumer = vertexConsumers.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)this.getTexture(player)));
        this.backpack.render(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
        matrices.popPose();
    }
}

