/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.mixin;

import com.yyz.yyzsbackpack.BackpackHelper;
import com.yyz.yyzsbackpack.BackpackManager;
import com.yyz.yyzsbackpack.BackpackPlatform;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Inventory.class})
public abstract class PlayerInventoryMixin {
    @Shadow
    @Final
    public Player player;
    @Shadow
    @Final
    public NonNullList<ItemStack> items;

    @Shadow
    public abstract int getSlotWithRemainingSpace(ItemStack var1);

    @Shadow
    public abstract int getFreeSlot();

    @Shadow
    public abstract boolean add(int var1, ItemStack var2);

    @Shadow
    public abstract ItemStack getItem(int var1);

    @ModifyArg(method={"<init>(Lnet/minecraft/world/entity/player/Player;)V"}, index=0, at=@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/core/NonNullList;withSize(ILjava/lang/Object;)Lnet/minecraft/core/NonNullList;"))
    private int modifyMainSize(int size) {
        return size + 54 + 1;
    }

    @Redirect(method={"getFreeSlot()I"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/NonNullList;size()I"))
    private int modifyLoopCount(NonNullList<ItemStack> instance) {
        return BackpackManager.getBackpackSize(this.player);
    }

    @Redirect(method={"findSlotMatchingItem(Lnet/minecraft/world/item/ItemStack;)I"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/NonNullList;size()I"))
    private int modifyFindSlotMatchingItem(NonNullList<ItemStack> instance) {
        return BackpackManager.getBackpackSize(this.player);
    }

    @Redirect(method={"findSlotMatchingUnusedItem(Lnet/minecraft/world/item/ItemStack;)I"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/NonNullList;size()I"))
    private int modifyFindSlotMatchingUnusedItem(NonNullList<ItemStack> instance) {
        return BackpackManager.getBackpackSize(this.player);
    }

    @Redirect(method={"getSlotWithRemainingSpace(Lnet/minecraft/world/item/ItemStack;)I"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/NonNullList;size()I"))
    private int modifyGetSlotWithRemainingSpace(NonNullList<ItemStack> instance) {
        return BackpackManager.getBackpackSize(this.player);
    }

    @Inject(method={"placeItemBackInInventory(Lnet/minecraft/world/item/ItemStack;Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void placeItemBackInInventory(ItemStack itemStack, boolean bl, CallbackInfo ci) {
        ci.cancel();
        while (!itemStack.isEmpty()) {
            int i = this.getSlotWithRemainingSpace(itemStack);
            if (i == -1) {
                i = this.getFreeSlot();
            }
            if (i != -1 && i < BackpackManager.getBackpackSize(this.player)) {
                int j = itemStack.getMaxStackSize() - this.getItem(i).getCount();
                if (!this.add(i, itemStack.split(j)) || !bl || !(this.player instanceof ServerPlayer)) continue;
                ((ServerPlayer)this.player).connection.send((Packet)new ClientboundContainerSetSlotPacket(-2, 0, i, this.getItem(i)));
                continue;
            }
            this.player.drop(itemStack, false);
            break;
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    private void addSlot(CallbackInfo ci) {
        if (BackpackHelper.getEquipped(this.player).has(BackpackPlatform.getBackpackItemsComponent())) {
            BackpackManager.restoreBackpackContents((Container)this.player.getInventory(), BackpackHelper.getEquipped(this.player));
        }
    }
}

