/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.mixin;

import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackHelper;
import com.yyz.yyzsbackpack.BackpackManager;
import com.yyz.yyzsbackpack.item.BackpackItem;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerEntityMixin {
    @Inject(method={"die(Lnet/minecraft/world/damagesource/DamageSource;)V"}, at={@At(value="HEAD")})
    private void onPlayerDeath(CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)this;
        Inventory inventory = player.getInventory();
        ItemStack stack = BackpackHelper.getEquipped((Player)player);
        if (stack.getItem() instanceof BackpackItem) {
            BackpackManager.saveBackpackContents((Container)inventory, stack, BackpackHelper.getEmptyRule((Player)player));
        }
    }

    @Inject(method={"initMenu(Lnet/minecraft/world/inventory/AbstractContainerMenu;)V"}, at={@At(value="HEAD")})
    private void onOpenMenu(CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)this;
        if (player.level().isClientSide) {
            return;
        }
        Inventory inventory = player.getInventory();
        ItemStack stackInSlot36 = inventory.getItem(90);
        if (stackInSlot36.getItem() instanceof BackpackItem && BackpackManager.isTrinketModLoaded() && !Backpack.getConfig().force_slot) {
            BackpackManager.saveBackpackContents((Container)inventory, stackInSlot36, true);
            inventory.setItem(90, ItemStack.EMPTY);
            if (!inventory.add(stackInSlot36)) {
                player.spawnAtLocation(stackInSlot36, 1.0f);
            }
        }
    }
}

