/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.neoforge.mixin.compat.itemindicator;

import com.yyz.yyzsbackpack.BackpackHelper;
import com.yyz.yyzsbackpack.item.BackpackItem;
import de.guntram.mcmod.durabilityviewer.itemindicator.InventorySlotsIndicator;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={InventorySlotsIndicator.class})
public class InventorySlotsIndicatorMixin {
    @Mutable
    @Shadow(remap=false)
    @Final
    ItemStack stack;
    @Mutable
    @Shadow(remap=false)
    @Final
    int emptySlots;

    @Inject(method={"<init>(Lnet/minecraft/world/entity/player/Inventory;)V"}, at={@At(value="RETURN")})
    private void injected(Inventory inventory, CallbackInfo ci) {
        this.stack = new ItemStack((ItemLike)Blocks.CHEST);
        int slots = 0;
        int effectiveSize = this.getEffectiveInventorySize(inventory) + 1;
        for (int i = 0; i < effectiveSize; ++i) {
            ItemStack itemStack = (ItemStack)inventory.items.get(i);
            if (!itemStack.isEmpty() || i == 36) continue;
            ++slots;
        }
        this.emptySlots = slots;
    }

    @Unique
    private int getEffectiveInventorySize(Inventory inventory) {
        Item item;
        ItemStack backpackStack = BackpackHelper.getEquipped(inventory.player);
        if (!backpackStack.isEmpty() && (item = backpackStack.getItem()) instanceof BackpackItem) {
            BackpackItem backpackItem = (BackpackItem)item;
            return 36 + backpackItem.getBackpackType().getColumns() * 9;
        }
        return 36;
    }
}

