/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.util;

import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.BackpackPlatform;
import com.yyz.yyzsbackpack.base.BackpackEffect;
import com.yyz.yyzsbackpack.item.BackpackItem;
import com.yyz.yyzsbackpack.util.BackpackHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_6880;

public class BackpackStorage {
    public static void saveBackpackContents(class_1263 inventory, class_1799 backpackStack, boolean b) {
        BackpackItem backpackItem = (BackpackItem)backpackStack.method_7909();
        int numSlots = backpackItem.getBackpackType().getSize();
        ArrayList<class_1799> items = new ArrayList<class_1799>(numSlots);
        for (int i = 0; i < numSlots; ++i) {
            int slotIndex = 36 + i;
            class_1799 stack = inventory.method_5438(slotIndex);
            items.add(stack.method_7972());
            if (!b) continue;
            inventory.method_5447(slotIndex, class_1799.field_8037);
        }
        backpackStack.method_57379(BackpackPlatform.getBackpackItemsComponent(), items);
    }

    public static void restoreBackpackContents(class_1263 inventory, class_1799 backpackStack) {
        List items = (List)backpackStack.method_57824(BackpackPlatform.getBackpackItemsComponent());
        if (items == null) {
            return;
        }
        BackpackItem backpackItem = (BackpackItem)backpackStack.method_7909();
        int numSlots = backpackItem.getBackpackType().getSize();
        for (int i = 0; i < Math.min(items.size(), numSlots); ++i) {
            class_1799 stack = (class_1799)items.get(i);
            if (stack.method_7960()) continue;
            inventory.method_5447(36 + i, stack.method_7972());
        }
        backpackStack.method_57381(BackpackPlatform.getBackpackItemsComponent());
    }

    public static int countNonEmptyBackpacks(class_1263 playerInventory) {
        int nonEmptyBackpackCount = 0;
        block0: for (int slot = 0; slot < playerInventory.method_5439(); ++slot) {
            List backpackItems;
            class_1799 stack = playerInventory.method_5438(slot);
            if (!(stack.method_7909() instanceof BackpackItem) || (backpackItems = (List)stack.method_57824(BackpackPlatform.getBackpackItemsComponent())) == null) continue;
            for (class_1799 content : backpackItems) {
                if (content.method_7960()) continue;
                ++nonEmptyBackpackCount;
                continue block0;
            }
        }
        return nonEmptyBackpackCount;
    }

    public static void updateEffectsByBackpackCount(class_1657 player, List<class_6880<class_1291>> lastAppliedEffects) {
        int backpackCount = BackpackStorage.countNonEmptyBackpacks((class_1263)player.method_31548());
        for (class_6880<class_1291> effect : new ArrayList<class_6880<class_1291>>(lastAppliedEffects)) {
            player.method_6016(effect);
            lastAppliedEffects.remove(effect);
        }
        List<BackpackEffect> effects = Backpack.getConfig().backpack_multi_effects;
        if (backpackCount > 0 && !effects.isEmpty()) {
            int effectIndex = Math.min(backpackCount, effects.size()) - 1;
            BackpackEffect effect = effects.get(effectIndex);
            class_6880<class_1291> effectType = BackpackHelper.getEffectHolder(effect.effectType);
            if (effectType == null) {
                return;
            }
            player.method_37222(new class_1293(effectType, -1, effect.amplifier), (class_1297)player);
            if (!lastAppliedEffects.contains(effectType)) {
                lastAppliedEffects.add(effectType);
            }
        }
    }

    public static void returnBackpackFromAccessorySlot(class_1657 player) {
        int ACCESSORY_SLOT;
        if (player.method_37908().field_9236) {
            return;
        }
        class_1661 inventory = player.method_31548();
        class_1799 accessoryItem = inventory.method_5438(ACCESSORY_SLOT = 36 + BackpackHelper.getMaxBackpackSize());
        if (accessoryItem.method_7909() instanceof BackpackItem && BackpackHelper.isTrinketModLoaded() && !Backpack.getConfig().use_dedicated_slot) {
            BackpackStorage.saveBackpackContents((class_1263)inventory, accessoryItem, true);
            inventory.method_5447(ACCESSORY_SLOT, class_1799.field_8037);
            if (!inventory.method_7394(accessoryItem)) {
                player.method_7328(accessoryItem, false);
            }
        }
    }

    public static void saveEquippedBackpackOnDeath(class_3222 player) {
        class_1799 equippedBackpack = BackpackPlatform.getEquipped((class_1657)player);
        if (equippedBackpack.method_7909() instanceof BackpackItem) {
            BackpackStorage.saveBackpackContents((class_1263)player.method_31548(), equippedBackpack, BackpackPlatform.getEmptyRule((class_1657)player));
        }
    }

    public static void restoreNonEmptyBackpack(class_1657 player) {
        class_1799 equippedBackpack = BackpackPlatform.getEquipped(player);
        if (equippedBackpack.method_57826(BackpackPlatform.getBackpackItemsComponent())) {
            BackpackStorage.restoreBackpackContents((class_1263)player.method_31548(), equippedBackpack);
        }
    }
}

