/*
 * Decompiled with CFR 0.152.
 */
package com.yyz.yyzsbackpack.neoforge;

import com.mojang.serialization.Codec;
import com.yyz.yyzsbackpack.Backpack;
import com.yyz.yyzsbackpack.item.BackpackItem;
import com.yyz.yyzsbackpack.item.BackpackMaterial;
import com.yyz.yyzsbackpack.neoforge.compat.curios.CuriosContainerAdapter;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mod(value="yyzsbackpack")
public final class BackpackNeoForge {
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENTS = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"yyzsbackpack");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"yyzsbackpack");
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"yyzsbackpack");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> BACKPACK_TAB = TABS.register("backpack_tab", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)GOLD_BACKPACK.get())).title((Component)Component.translatable((String)"itemGroup.yyzsbackpack.title")).displayItems((context, entries) -> {
        entries.accept((ItemLike)WOOLEN_BACKPACK.get());
        entries.accept((ItemLike)STONE_BACKPACK.get());
        entries.accept((ItemLike)IRON_BACKPACK.get());
        entries.accept((ItemLike)GOLD_BACKPACK.get());
        entries.accept((ItemLike)DIAMOND_BACKPACK.get());
        entries.accept((ItemLike)NETHERITE_BACKPACK.get());
    }).build());
    public static final DeferredHolder<Item, Item> NETHERITE_BACKPACK = ITEMS.register("netherite_backpack", () -> new BackpackItem(BackpackMaterial.NETHERITE, new Item.Properties().stacksTo(1).fireResistant()));
    public static final DeferredHolder<Item, Item> DIAMOND_BACKPACK = ITEMS.register("diamond_backpack", () -> new BackpackItem(BackpackMaterial.DIAMOND, new Item.Properties().stacksTo(1)));
    public static final DeferredHolder<Item, Item> GOLD_BACKPACK = ITEMS.register("gold_backpack", () -> new BackpackItem(BackpackMaterial.GOLD, new Item.Properties().stacksTo(1)));
    public static final DeferredHolder<Item, Item> IRON_BACKPACK = ITEMS.register("iron_backpack", () -> new BackpackItem(BackpackMaterial.IRON, new Item.Properties().stacksTo(1)));
    public static final DeferredHolder<Item, Item> STONE_BACKPACK = ITEMS.register("stone_backpack", () -> new BackpackItem(BackpackMaterial.STONE, new Item.Properties().stacksTo(1)));
    public static final DeferredHolder<Item, Item> WOOLEN_BACKPACK = ITEMS.register("woolen_backpack", () -> new BackpackItem(BackpackMaterial.WOOLEN, new Item.Properties().stacksTo(1)));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<List<ItemStack>>> BACKPACK_ITEMS_COMPONENT = DATA_COMPONENTS.register("backpack_items", () -> DataComponentType.builder().persistent(Codec.list((Codec)ItemStack.OPTIONAL_CODEC)).build());

    public BackpackNeoForge(IEventBus modEventBus) {
        ITEMS.register(modEventBus);
        TABS.register(modEventBus);
        DATA_COMPONENTS.register(modEventBus);
        Backpack.init();
    }

    public static ItemStack getEquipped(Player player) {
        Optional backpackSlot;
        Optional curiosHandler;
        if (FMLLoader.getLoadingModList().getModFileById("curios") != null && (curiosHandler = CuriosApi.getCuriosInventory((LivingEntity)player)).isPresent() && (backpackSlot = ((ICuriosItemHandler)curiosHandler.get()).findFirstCurio(stack -> stack.getItem() instanceof BackpackItem)).isPresent()) {
            return ((SlotResult)backpackSlot.get()).stack();
        }
        return player.getInventory().getItem(36);
    }

    public static Container getContainer(Player player) {
        Optional backpackSlot;
        Optional curiosHandler;
        if (FMLLoader.getLoadingModList().getModFileById("curios") != null && (curiosHandler = CuriosApi.getCuriosInventory((LivingEntity)player)).isPresent() && (backpackSlot = ((ICuriosItemHandler)curiosHandler.get()).findFirstCurio(stack -> stack.getItem() instanceof BackpackItem)).isPresent()) {
            SlotContext slotContext = ((SlotResult)backpackSlot.get()).slotContext();
            String slotId = slotContext.identifier();
            int slotIndex = slotContext.index();
            Optional stacksHandler = ((ICuriosItemHandler)curiosHandler.get()).getStacksHandler(slotId);
            if (stacksHandler.isPresent()) {
                return new CuriosContainerAdapter(((ICurioStacksHandler)stacksHandler.get()).getStacks(), slotIndex);
            }
        }
        return player.getInventory();
    }

    public static int getIndex(Player player) {
        Container container;
        Optional backpackSlot;
        Optional curiosHandler;
        if (FMLLoader.getLoadingModList().getModFileById("curios") != null && (curiosHandler = CuriosApi.getCuriosInventory((LivingEntity)player)).isPresent() && (backpackSlot = ((ICuriosItemHandler)curiosHandler.get()).findFirstCurio(stack -> stack.getItem() instanceof BackpackItem)).isPresent() && (container = BackpackNeoForge.getContainer(player)) instanceof CuriosContainerAdapter) {
            return ((CuriosContainerAdapter)container).getBackpackSlotIndex();
        }
        return 36;
    }
}

